package com.youqian.api.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;
import java.io.Serializable;

/**
 * @author tengtuox
 * @date 2020/11/23
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrgUpdateRequest extends Operator implements Serializable {

    @PositiveOrZero(message = "部门ID必须大于等于0")
    @NotNull(message = "部门ID不能为空")
    @ApiModelProperty(value = "部门ID", required = true)
    private Long orgId;

//    @ApiModelProperty("上级部门ID")
//    private Long parentOrgId;

    @NotBlank(message = "部门名称不能为空")
    @ApiModelProperty(value = "部门名称", required = true)
    private String orgName;

}
