package com.youqian.api.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xiachenhang
 */
@Data
public class LiveGoodsListResult implements Serializable {
    /**
     * 图片列表
     */
    private List<GoodsImageResult> goodsImageList;
    /**
     * 商品ID
     */
    private Long goodsId;
    /**
     * 商品名字
     */
    private String name;
    /**
     * 商品款号
     */
    private String shortName;
    /**
     * 商品属性文案
     */
    private String attributeText;
    /**
     * 序号
     */
    private Integer liveOrder;
    /**
     * 颜色
     */
    private Integer colorCount;
    /**
     * 规格
     */
    private Integer sizeCount;
    /**
     * 选择件数
     */
    private Integer chooseCount;
    /**
     * 是否存在订单
     */
    private Boolean hasOrder;
    /**
     * 是否询价
     */
    private Byte enquiry;
    /**
     * 若存在订单,报单Id
     */
    private Long orderReportBillId;
    /**
     * 是否有其他商品图
     */
    private Boolean hasOtherPic;

    /**
     * 商品图片数量
     */
    private Integer countProductPictures;

    /**
     * 是否需要二次预约
     */
    private byte needOrder;

    /**
     * 有截止日期的情况
     */
    private Date expireDate;
}
