package com.youqian.api.response;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author tengtuox
 * @date 2020/10/29
 * @description
 */
@Data
public class MerchantApplyResult implements Serializable {

    /**
     * 申请ID
     */
    private Long merchantApplyId;

    /**
     * 商户名称
     */
    private String merchantName;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户手机号码
     */
    private String customerMobile;

    /**
     * 省编码
     */
    private String provinceCode;

    /**
     * 市编码
     */
    private String cityCode;

    /**
     * 区编码
     */
    private String areaCode;

    /**
     * 完整地址
     */
    private String detailArea;

    /**
     * 开单销售商户ID
     */
    private Long sellerMerchantId;

    /**
     * 销售商户名称
     */
    private String sellerMerchantName;

    /**
     * 开单销售员工ID
     */
    private Long sellerEmployeeId;

    /**
     * 销售员工名称
     */
    private String sellerEmployeeName;

    /**
     * 0-未开户/1-已开户
     */
    private Byte applyStatus;

    /**
     * 开户时间
     */
    private Date openTime;

    /**
     * 创建时间(提交时间)
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}
