package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/9/22
 * @description
 */
@Data
public class OrderCustomerStatisticsResult implements Serializable {

    @ApiModelProperty("商户ID")
    private Long merchantId;

    @ApiModelProperty("客户ID")
    private Long customerId;

    @ApiModelProperty("客户名称")
    private String customerName = "未知";

    @ApiModelProperty("客户企业")
    private String customerEnterpriseName = "未知";

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("开单数量")
    private Integer openOrderCount = 0;

    @ApiModelProperty("开单金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal openOrderMoney = BigDecimal.ZERO;

    @ApiModelProperty("发货数量")
    private Integer deliveryCount = 0;

    @ApiModelProperty("发货金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal deliveryMoney = BigDecimal.ZERO;

    @ApiModelProperty("回款/收款")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal moneyBack = BigDecimal.ZERO;

    @ApiModelProperty("待收款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal restMoney = BigDecimal.ZERO;

    @ApiModelProperty("开单人姓名")
    private List<String> createUserNameList;

}
