package com.youqian.api.response;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.youqian.api.util.BigDecimalSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author tengtuox
 * @date 2020/3/26
 * @description
 */
@Data
public class OrderPageResult implements Serializable {

    @ApiModelProperty("订单ID")
    private Long id;

    @ApiModelProperty("订单编号")
    private String orderNumber;

    @ApiModelProperty("卖（买）家头像")
    private String avatarUrl;

    @ApiModelProperty("卖（买）家名称")
    private String name;

    @ApiModelProperty("卖（买）家手机号")
    private String mobilePhone;

    @ApiModelProperty("公司名称/商户名称")
    private String companyName;

    @ApiModelProperty("开单人")
    private String createUserName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("订单状态")
    private Byte orderStatus;

    @ApiModelProperty("订单状态文字")
    private String orderStatusText;

    @ApiModelProperty("运费")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal transportFee;

    /*@ApiModelProperty("税费")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal tax;*/

    @ApiModelProperty("总应收款")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal totalPrice;

    @ApiModelProperty("优惠")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal reducePrice;

    @ApiModelProperty("原价")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal originOrderPrice;

    @ApiModelProperty("待收款金额")
    @JsonSerialize(using = BigDecimalSerializer.class)
    private BigDecimal toCheckBillPrice;

    @ApiModelProperty("货品列表")
    private List<OrderItemDetail> goodsList;

    @ApiModelProperty("订单确认时间")
    private Date confirmTime;

    @ApiModelProperty("发货时间（操作发货时间）")
    private Date deliveryTime;

    @ApiModelProperty("运输方式， 1-卖家送货/2-买家自提")
    private Byte transType;

    @ApiModelProperty("收货人名称")
    private String receiverName;

    @ApiModelProperty("收货人手机号码")
    private String receiverMobile;

    @ApiModelProperty("收货地址")
    private String receiverAddress;

    @ApiModelProperty("提货人")
    private String deliveryName;

    @ApiModelProperty("提货人手机号码")
    private String deliveryMobile;

    @ApiModelProperty("提货地址")
    private String deliveryAddress;

    @ApiModelProperty("订单备注")
    private String orderRemark;
}
