package com.youqian.api.response;

import com.youqian.api.dto.order.OrderMainDto;
import com.youqian.api.request.Operator;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author tengtuox
 * @date 2020/12/1
 * @description
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OrderRole extends Operator implements Serializable {

    /**
     * 订单
     */
    private OrderMainDto orderMainDto;

    /**
     * 是否是这个订单的商户管理员
     */
    private Boolean admin = Boolean.FALSE;

    /**
     * 是否是这个订单的部门管理员
     */
    private Boolean orgAdmin = Boolean.FALSE;

    /**
     * 是否是这个订单的负责销售
     */
    private Boolean orderSeller = Boolean.FALSE;

    /**
     * 是否是这个订单的创建人
     */
    private Boolean createOrderSeller = Boolean.FALSE;

    /**
     * 是否有发货权限
     */
    public boolean canDelivery() {
        return admin || orgAdmin || orderSeller;
    }

    /**
     * 是否有收款权限
     */
    public boolean canMoneyBack() {
        return admin || orgAdmin || orderSeller;
    }

    /**
     * 是否有查看收款权限
     */
    public boolean canLookMoneyBack() {
        return canMoneyBack();
    }

    /**
     * 是否有取消订单权限
     */
    public boolean canCancel() {
        return admin || orgAdmin || orderSeller;
    }

    /**
     * 是否有修改订单权限
     */
    public boolean canModify() {
        return admin || orgAdmin || orderSeller;
    }

    /**
     * 是否有发送给客户权限
     */
    public boolean canSendCustomer() {
        return admin || orgAdmin || orderSeller;
    }

    /**
     * 是否有确认订单权限
     */
    public boolean canConfirm() {
        return Objects.equals(orderMainDto.getCustomerMobile(), getOperatorMobile());
    }
}
