package com.youqian.api.response.wms;

import com.youqian.uid.annotation.AutoId;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class WmsSkuDozenResult {

    /**
     * 件规id
     * not null default = null
     */
    private Long dozenId;


    /**
     * 商品规格
     * not null default = null
     */
    private Integer goodsSpec;

    /**
     * 包装规格
     * not null default = 0
     */
    private Integer packageSpec;

    /**
     * 件规名称
     goods_spec*package_spec
     * max length = 50
     * not null default = null
     */
    private String dozenName;

    /**
     * 库存数量
     * not null default = 0
     */
    private Integer totalQuantity;

    /**
     * 可用库存数量
     * not null default = 0
     */
    private Integer availableQuantity;

    /**
     * 已售商品数量
     * not null default = 0
     */
    private Integer soldQuantity;

    /**
     * 体积
     * not null default = null
     */
    private BigDecimal cubage;

    /**
     * 重量
     * not null default = null
     */
    private BigDecimal weight;

    /**
     * 商品skuid
     * not null default = 0
     */
    private Long shopGoodsSkuId;
}
