package com.youqian.api.response.wms;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class WmsSkuResult {

    /**
     * 唯一id
     * not null default = null
     */
    private Long shopGoodsSkuId;

    /**
     * 商品id
     */
    private Long goodsId;

    /**
     * 库存
     */
    private Integer total;

    /**
     * 编号
     * max length = 255
     */
    private String sn;

    /**
     * 名称
     * max length = 100
     */
    private String name;

    /**
     * 商品规格码
     * max length = 255
     */
    private String goodsSpecCode;

    /**
     * 规格字符串
     * max length = 255
     */
    private String specToString;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 商户id
     * not null default = null
     */
    private Long merchantId;


    /**
     * 商品缩略图
     */
    private String thumb;

    /**
     * 可用商品数量
     */
    private  Integer availableQuantity;

    /**
     * 已售商品数量
     */
    private  Integer soldQuantity;

    /**
     * 商品下件规总数
     */
    private Integer dozenNum;

    /**
     * 商品缩略图
     */
    private String goodsThumb;

    /**
     * 单位
     */
    private String unit;

    /**
     * 商品名
     */
    private String goodsName;

    /**
     * 商品编号
     */
    private String shortName;
}
