package com.youqian.api.enums;

import lombok.Getter;

import java.util.Objects;

@Getter
public enum InviteTypeEnum {
    INVITE_1((byte)1,"订阅到场"),
    INVITE_2((byte)2,"未订阅到场"),
    INVITE_3((byte)3,"订阅未到场"),
    INVITE_4((byte)4,"未订阅未到场"),
    INVITE_5((byte)5,"新访客"),
    ;

    private byte code;
    private String msg;

    InviteTypeEnum(byte code,String msg){
        this.code = code;
        this.msg = msg;
    }

    public static InviteTypeEnum get(Byte code){
        if(code == null){
            return null;
        }
        for(InviteTypeEnum inviteTypeEnum:values()){
            if(Objects.equals(inviteTypeEnum.getCode(),code)){
                return inviteTypeEnum;
            }
        }
        return null;
    }
}
