/*
 * Decompiled with CFR 0.152.
 */
package com.youqian.auth.api.common.redis;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.cache.CacheLoader;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class Cache
implements ApplicationContextAware {
    private String keyPrefix;
    @Resource(name="redisTemplate")
    private AdvancedCacheClient advancedCacheClient;
    @Autowired
    private RedisTemplate redisTemplate;
    private ApplicationContext applicationContext;

    public <T> T get(String key) {
        return (T)this.advancedCacheClient.get(this.getRealKey(key));
    }

    public boolean set(String key, Object value, int expSeconds) {
        return this.advancedCacheClient.set(this.getRealKey(key), value, expSeconds, TimeUnit.SECONDS);
    }

    public <T> T getWithCacheLoader(String key, int expSeconds, boolean isCacheNull, CacheLoader<T> cacheLoader) {
        return (T)this.advancedCacheClient.getWithCacheLoader(this.getRealKey(key), expSeconds, TimeUnit.SECONDS, isCacheNull, cacheLoader);
    }

    public <T> T getWithCacheLoader(String key, int expSeconds, CacheLoader<T> cacheLoader) {
        return (T)this.advancedCacheClient.getWithCacheLoader(this.getRealKey(key), expSeconds, TimeUnit.SECONDS, cacheLoader);
    }

    public boolean remove(String key) {
        return this.advancedCacheClient.remove(this.getRealKey(key));
    }

    public boolean remove(String ... keys) {
        return this.advancedCacheClient.remove(this.getRealKeys(keys));
    }

    private String getRealKey(String key) {
        if (key.startsWith(this.keyPrefix)) {
            return key;
        }
        return this.keyPrefix + key;
    }

    private String[] getRealKeys(String ... keys) {
        String[] realKeys = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key.startsWith(this.keyPrefix)) {
                realKeys[i] = key;
            }
            realKeys[i] = this.keyPrefix + key;
        }
        return realKeys;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.keyPrefix = "youqian:" + this.getCurrentEnv() + ":";
    }

    public String getCurrentEnv() {
        if (SpringEnvironmentUtils.isDevEnv((ApplicationContext)this.applicationContext)) {
            return "dev";
        }
        if (SpringEnvironmentUtils.isTestEnv((ApplicationContext)this.applicationContext)) {
            return "test";
        }
        if (SpringEnvironmentUtils.isPreEnv((ApplicationContext)this.applicationContext)) {
            return "pre";
        }
        if (SpringEnvironmentUtils.isProdEnv((ApplicationContext)this.applicationContext)) {
            return "prod";
        }
        throw new IllegalStateException("\u6ca1\u6709\u83b7\u53d6\u7cfb\u7edf\u73af\u5883");
    }

    public Long increment(String key, int delta) {
        return this.redisTemplate.opsForValue().increment((Object)this.getRealKey(key), (long)delta);
    }
}

