package com.youqian.auth.api.enums;

import com.youqian.auth.api.exception.ErrorCode;
import lombok.Getter;

/**
 * @author tengtuox
 * @date 2019/12/27
 * @description: 错误码
 */
@Getter
public enum StandardCode implements ErrorCode {

    SUCCESS(0, "success"),
    UNKNOWN_ERROR(500, "系统繁忙"),
    THIRD_ERROR(900, "第三方异常"),

    PARAM_ERROR(1000000, "参数错误"),
    AUTH_TYPE_NOT_EMPTY(400, "鉴权类型不能为空"),
    AUTH_TYPE_ERROR(401, "鉴权类型参数错误"),
    AUTH_TOKEN_NOT_EMPTY(402, "Token不能为空"),
    AUTH_TOKEN_ERROR(403, "Token有误"),
    PERMISSION_DENY(999999, "无权限"),

    // User错误10开头
    USER_NOT_EXISTS(100001, "用户不存在"),
    PASSWORD_ERROR(100002, "密码错误"),
    USER_ALREADY_EXISTS(100003, "用户已存在"),
    USER_NOT_AUTH(100004, "用户未认证"),
    ADDRESS_NOT_EXISTS(100005, "地址不存在"),
    USER_ROLE_EXISTS(100006, "用户权限不能为空"),
    BUY_USER_NOT_EXISTS(100007, "买家手机号不能为空"),
    BUY_USER_NAME_NOT_EXISTS(100008, "买家姓名不能为空"),
    ADDRESS_NOT_NULL(100009,"地址不能为空"),
    USER_AUTH_NOT_MATCH(100010,"用户信息未匹配"),
    USER_3_NOT_MATCH(100011,"三要素信息未匹配"),
    USER_INFO_NOT_COMPLETE(100012,"用户信息不完整,请修改信息"),
    USER_DELIVERY_TIME_LESS_THAN_TODAY(100013,"收货时间从今天开始"),
    ACCOUNT_NOT_EXISTS(100015, "账号不存在"),
    MESSAGE_CODE_ERROR(100014, "账号或验证码错误"),
    USER_UPDATE_ERROR(110016, "用户更新失败"),
    USER_AUTH_STATUS_ERROR(100017,"用户认证状态有误"),

    // Merchant 11开头createToken
    MERCHANT_NOT_EXISTS(110001, "商户不存在"),
    EMPLOYEE_ALREADY_HAS_MERCHANT(110002, "员工已经加入了一个商户, 不能重复加入"),
    EMPLOYEE_NOT_EXISTS(110003, "员工不存在"),
    MERCHANT_ALREADY_EXISTS(110004, "商户名称已存在"),
    SIGN_ENTITY_NOT_EXISTS(110005, "签约主体不存在"),
    ORG_ALREADY_EXISTS(110006, "组织已存在"),
    MERCHANT_PERMISSION_DENY(110007, "你没有该商户的权限"),
    MERCHANT_TEMPLATE_EXISTS(110008, "模板已添加"),
    MERCHANT_TEMPLATE_NOT_EXISTS(110009, "模板不存在"),
    GOODS_SPEC_EXISTS(110010, "商品已存在"),
    GOODS_SPEC_NOT_EXISTS(110011, "商品不存在"),
    SIGN_ENTITY_EXISTS(110012, "签约主体已存在"),
    ENT_4_NOT_MATCH(110013, "企业四要素不通过"),
    ENT_AUTH_NOT_EXISTS(110014, "企业未提交基本信息"),
    ENT_LEGAL_NOT_MATCH(110015, "企业和法人不匹配"),
    LEGAL_3_NOT_MATCH(110016, "法人三要素不匹配"),
    ENT_BELONG_OTHERS(110017, "当前企业已经属于其他商户"),
    ORG_NOT_EXISTS(110019, "组织不存在"),
    ENTITY_AUTH_EXISTS(110020, "实名信息已存在"),
    ENTITY_AUTH_NOT_EXISTS(110021, "实名信息未提交"),
    ENT_NAME_NOT_MATCH(110022, "企业名称不匹配"),
    SIGN_ENTITY_HAS_MERCHANT(110023, "当前企业已经属于其他商户"),
    MERCHANT_TAX_POINT_NOT_NULL(110024,"税点不能为空"),
    MERCHANT_TAX_POINT_IS_EXIST(110025,"默认税点存在.无需添加"),
    CUSTOMER_EXISTS(110026, "该客户已存在"),
    CUSTOMER_NOT_EXISTS(110027, "客户不存在"),
    MERCHANT_UPDATE_ERROR(110028, "商户更新失败"),

    // Manage 12开头
    MANAGE_USER_NOT_EXISTS(120001, "用户不存在"),
    MANAGE_PASSWORD_ERROR(120002, "账号或密码错误"),
    MANAGE_USER_ALREADY_EXISTS(120003, "用户已存在"),
    MANAGE_ROLE_EXISTS(120004, "角色已存在"),
    MANAGE_ROLE_NOT_EXISTS(120005, "角色不存在"),

    // Order 13开头
    ORDER_NOT_EXISTS(130001, "订单不存在"),
    ORDER_UPDATE_FAIL(130002, "订单更新失败"),
    ORDER_SIGN_NOT_UPDATE(130003, "签署订单不允许修改"),
    ORDER_ALREADY_SIGN(130004, "订单已签署"),
    ORDER_BUYER_INFO_NOT_PERSONAL(130005, "订单买家信息必须为本人"),
    ORDER_SHELL_INFO_NOT_PERSONAL(130006, "订单卖家信息必须为签约主体"),
    ORDER_NO_LOOK_POWER(130007, "没有查看当前订单的权限"),
    ORDER_STATUS_ERROR(130008, "操作有误"),
    ORDER_NAME_NOT_SAME(130009,"订单的买家姓名不能与卖家姓名一样"),
    PAY_ORDER_NOT_EXISTS(130010, "支付单不存在"),
    ORDER_SELL_INFO_NOT_PERSONAL(1300011, "必须为签约主体"),
    PAY_ORDER_ALREADY_EXISTS(1300012, "您已购买过一次，无法再次购买"),

    // Contract 14开头,
    TEMPLATE_NOT_EXISTS(140001, "合同模板不存在"),
    TEMPLATE_ALREADY_EXISTS(140002, "模板已存在"),
    TEMPLATE_CREATE_NOT_UPDATE(1400003, "合同生成不可修改"),

    //Img 15开头
    IMG_NOT_UPLOAD(150001, "请上传照片"),
    IMG_CONVERSION_FAIL(150002, "图片转换有误"),
    IMG_REPEAT_UPLOAD(150003, "信息认证中，请稍后再试"),
    IMG_REPEAT_UPLOAD_FAIL(150004, "信息认证失败"),


    //短信 16开头
    SEND_SMS_ERROR(160001, "发送短信验证码错误"),
    SMS_MOT_MATCH(160002, "短信验证码错误"),
    SMS_NOT_SEND(160003,"短信未发送"),
    SMS_CHECK_ERROR(160004,"短信校验有误"),


    //员工 17开头
    EMPLOYEE_UPDATE_ERROR(170001, "员工更新失败"),
  ;

    private Integer code;

    private String strCode;

    private String desc;

    StandardCode(Integer code, String desc) {
        this.code = code;
        this.strCode = String.valueOf(code);
        this.desc = desc;
    }

}
