/*
 * Decompiled with CFR 0.152.
 */
package com.credits.activity.sdk.component.share;

import com.credits.activity.sdk.SdkContext;
import com.credits.activity.sdk.common.ThreadPoolApi;
import com.credits.activity.sdk.common.prize.PrizeApi;
import com.credits.activity.sdk.common.prize.dto.PrizeRequestDTO;
import com.credits.activity.sdk.component.share.ShareApi;
import com.credits.activity.sdk.component.share.dto.InvitationDTO;
import com.credits.activity.sdk.component.share.dto.ShareDTO;
import com.credits.activity.sdk.component.share.dto.ShareForm;
import com.credits.activity.sdk.component.share.dto.ShareVO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class DefaultShareController {
    private static final Logger log = LoggerFactory.getLogger(DefaultShareController.class);
    @Autowired
    private ShareApi shareApi;
    @Autowired
    private ThreadPoolApi threadPoolApi;
    @Autowired
    private PrizeApi prizeStrategyApi;

    protected abstract ShareForm getForm();

    @GetMapping
    public ShareVO get(SdkContext ctx) {
        String url = this.shareApi.getShareUrl(ctx, "index");
        ShareVO vo = new ShareVO();
        vo.setShareTitle(this.getForm().getShareTitle());
        vo.setShareSubTitle(this.getForm().getShareSubTitle());
        vo.setShareImage(this.getForm().getShareImage());
        vo.setShareUrl(url);
        return vo;
    }

    @GetMapping(value={"index"})
    public void index(final SdkContext ctx, @RequestParam Long shareId, @RequestParam String to) throws Exception {
        final InvitationDTO add = this.shareApi.addInvitationRecord(ctx, shareId);
        if (add.isFirst()) {
            this.threadPoolApi.execute(new Runnable(){

                @Override
                public void run() {
                    PrizeRequestDTO prizeRequest = new PrizeRequestDTO();
                    prizeRequest.setPrizes(DefaultShareController.this.getForm().getSharePrizes());
                    ctx.setUserID(add.getShareUserId());
                    DefaultShareController.this.prizeStrategyApi.randomPrizeSync(ctx, prizeRequest);
                }
            });
        }
        ctx.getHttpServletResponse().sendRedirect(to);
    }

    @GetMapping
    public List<ShareDTO> record(SdkContext ctx) throws Exception {
        return this.shareApi.findInvitationRecord(ctx);
    }
}

