/*
 * Decompiled with CFR 0.152.
 */
package com.credits.activity.sdk.ctrl;

import com.credits.activity.sdk.SdkContext;
import com.credits.activity.sdk.common.annotation.log.LogBuried;
import com.credits.activity.sdk.common.annotation.log.LogEnum;
import com.credits.activity.sdk.common.utils.AssertUtils;
import com.credits.activity.sdk.component.task.TaskApi;
import com.credits.activity.sdk.component.task.dto.TaskItem;
import com.credits.activity.sdk.component.task.dto.TaskResult;
import com.credits.activity.sdk.component.task.dto.TaskVO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class DefaultTaskController {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskController.class);
    @Autowired
    private TaskApi api;

    protected abstract List<TaskItem> getTasks();

    @GetMapping
    public List<TaskVO> query() {
        return this.api.queryList(this.getTasks());
    }

    @LogBuried(type={LogEnum.D403, LogEnum.D404})
    @PostMapping
    public TaskResult done(SdkContext context, @RequestParam String taskId) {
        TaskItem task = this.api.query(taskId, this.getTasks());
        AssertUtils.isNull(task, "\u4efb\u52a1\u672a\u627e\u5230");
        return this.api.doTask(task);
    }

    @PostMapping
    public TaskResult doTask(SdkContext context, @RequestParam String taskId) {
        return this.done(context, taskId);
    }
}

