/*
 * Decompiled with CFR 0.152.
 */
package com.credits.activity.sdk.common.utils;

import com.credits.activity.sdk.common.exception.SdkRuntimeException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DateUtils {
    public static String formatYMD(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static Date formatYMD(String ydm) {
        LocalDate localDate = LocalDate.parse(ydm);
        LocalDateTime dateTime = LocalDateTime.of(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth(), 0, 0, 0);
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date format(String date, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(date);
        }
        catch (ParseException var3) {
            throw new SdkRuntimeException(var3);
        }
    }

    public static String formatYMDHMS(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static Date formatYMD00(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDateTime dateTime = LocalDateTime.of(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth(), 0, 0, 0);
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date formatYMD24(Date date) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDateTime dateTime = LocalDateTime.of(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth(), 23, 59, 59, 9999);
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date formatHMS(Date date, int hour, int minute, int second) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDateTime dateTime = LocalDateTime.of(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth(), hour, minute, second);
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date plusDays(Date date, int day) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return Date.from(localDateTime.plusDays(day).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date plusHours(Date date, int hours) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return Date.from(localDateTime.plusHours(hours).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date plusMinutes(Date date, int minutes) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return Date.from(localDateTime.plusMinutes(minutes).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static int getYear(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.getYear();
    }

    public static int getMonth(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.getMonth().getValue();
    }

    public static int getDay(Date date) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime.getDayOfMonth();
    }

    public static Date getWeekDay(Date date, int day) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDate localDate = localDateTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.of(day))).toLocalDate();
        LocalDateTime dateTime = LocalDateTime.of(localDate.getYear(), localDate.getMonth(), localDate.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getMonthDay(Date date, int day) {
        LocalDateTime localDateTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDate localDate = localDateTime.toLocalDate();
        LocalDateTime dateTime = LocalDateTime.of(localDate.getYear(), localDate.getMonth(), day, localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getFirstDayOfWeek(Date time) {
        LocalDate date = time.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate first = date.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDateTime firstDateTime = LocalDateTime.of(first.getYear(), first.getMonth(), first.getDayOfMonth(), 0, 0, 0);
        return Date.from(firstDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getLastDayOfWeek(Date time) {
        LocalDate date = time.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate last = date.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        LocalDateTime lastDateTime = LocalDateTime.of(last.getYear(), last.getMonth(), last.getDayOfMonth(), 23, 59, 59, 9999);
        return Date.from(lastDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getFirstDayOfMonth(Date time) {
        LocalDate date = time.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate first = date.with(TemporalAdjusters.firstDayOfMonth());
        LocalDateTime firstDateTime = LocalDateTime.of(first.getYear(), first.getMonth(), first.getDayOfMonth(), 0, 0, 0);
        return Date.from(firstDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getLastDayOfMonth(Date time) {
        LocalDate date = time.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate last = date.with(TemporalAdjusters.lastDayOfMonth());
        LocalDateTime lastDateTime = LocalDateTime.of(last.getYear(), last.getMonth(), last.getDayOfMonth(), 23, 59, 59, 9999);
        return Date.from(lastDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static long getTodaySeconds() {
        Long current = System.currentTimeMillis();
        Long zero = DateUtils.plusDays(new Date(), 1).getTime();
        return (zero - current) / 1000L;
    }

    public static long getTodaySecondsAddRandom() {
        long remainSeconds = DateUtils.getTodaySeconds();
        int random = (int)(Math.random() * 180.0) + 600;
        return remainSeconds + (long)random;
    }

    public static List<Date> getListDay(Date start, Date end) {
        ArrayList<Date> days = new ArrayList<Date>();
        if (start != null && end != null) {
            long d;
            LocalDate s = start.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate e = end.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            for (long i = d = e.toEpochDay() - s.toEpochDay(); i >= 0L; --i) {
                days.add(Date.from(e.minusDays(i).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
            }
            return days;
        }
        if (start != null) {
            days.add(start);
            return days;
        }
        if (end != null) {
            days.add(end);
            return days;
        }
        return days;
    }

    public static long getDays(Date start, Date end) {
        LocalDate s = start.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate e = end.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return e.toEpochDay() - s.toEpochDay();
    }

    public static String getDayOfYear() {
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        int day = now.getDayOfYear();
        return year + "" + day;
    }

    public static String getWeekOfYear() {
        LocalDate now = LocalDate.now();
        WeekFields weekFields = WeekFields.of(Locale.getDefault());
        int year = now.getYear();
        int weekNumber = now.get(weekFields.weekOfWeekBasedYear());
        return year + "" + weekNumber;
    }

    public static String getMonthOfYear() {
        LocalDate now = LocalDate.now();
        int year = now.getYear();
        int month = now.getMonthValue();
        return year + "" + month;
    }
}

