/*
 * Decompiled with CFR 0.152.
 */
package com.credits.activity.sdk.common.utils;

import com.credits.activity.sdk.common.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class UrlUtils {
    public static String appendParams(String url, Map<String, String> params) {
        StringBuilder sb = new StringBuilder(url);
        if (sb.indexOf("?") != -1) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(UrlUtils.buildUrlEncodeParams(params));
        return sb.toString();
    }

    public static String buildUrlEncodeParams(Map<String, String> params) {
        if (params != null && !params.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                sb.append(entry.getKey()).append("=").append(UrlUtils.encode(entry.getValue())).append("&");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        return "";
    }

    public static Map<String, String> getUrlParams(String url) {
        String[] splits;
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isEmpty(url)) {
            return new HashMap<String, String>();
        }
        if (url.contains("?")) {
            url = url.substring(url.indexOf("?") + 1);
        }
        String[] var3 = splits = url.split("&");
        int var4 = splits.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String kvs = var3[var5];
            String[] kv = kvs.split("=");
            if (kv.length != 2) continue;
            params.put(kv[0], kv[1]);
        }
        return params;
    }

    public static String decode(String url) {
        try {
            return URLDecoder.decode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getDecodedUrlParams(String url) {
        try {
            String[] splits;
            HashMap<String, String> params = new HashMap<String, String>();
            if (StringUtils.isEmpty(url)) {
                return new HashMap<String, String>();
            }
            if (url.contains("?")) {
                url = url.substring(url.indexOf("?") + 1);
            }
            String[] var3 = splits = url.split("&");
            int var4 = splits.length;
            for (int var5 = 0; var5 < var4; ++var5) {
                String kvs = var3[var5];
                String[] kv = kvs.split("=");
                if (kv.length != 2) continue;
                params.put(kv[0], URLDecoder.decode(kv[1], "utf-8"));
            }
            return params;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

