/*
 * Decompiled with CFR 0.152.
 */
package com.credits.activity.sdk.ctrl;

import com.alibaba.fastjson.JSONObject;
import com.credits.activity.sdk.SdkContext;
import com.credits.activity.sdk.common.ConfineApi;
import com.credits.activity.sdk.common.ProjectApi;
import com.credits.activity.sdk.common.UserApi;
import com.credits.activity.sdk.common.annotation.BackendAction;
import com.credits.activity.sdk.common.annotation.log.LogBuried;
import com.credits.activity.sdk.common.annotation.log.LogEnum;
import com.credits.activity.sdk.common.dto.CreditsDTO;
import com.credits.activity.sdk.common.dto.ProjectDTO;
import com.credits.activity.sdk.common.dto.SdkPage;
import com.credits.activity.sdk.common.dto.SdkPageQuery;
import com.credits.activity.sdk.common.dto.UserDTO;
import com.credits.activity.sdk.component.answer.AnswerApi;
import com.credits.activity.sdk.component.answer.dto.AnswerReportVO;
import com.credits.activity.sdk.component.answer.dto.AnswerResult;
import com.credits.activity.sdk.component.answer.dto.AnswerStart;
import com.credits.activity.sdk.component.answer.dto.AnswerStartResult;
import com.credits.activity.sdk.component.answer.dto.SubjectForm;
import com.credits.activity.sdk.component.answer.dto.SubjectFormVO;
import com.credits.activity.sdk.component.answer.dto.SubmitAnswer;
import com.credits.activity.sdk.component.answer.dto.SubmitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class DefaultAnswerController {
    private static final Logger log = LoggerFactory.getLogger(DefaultAnswerController.class);
    @Autowired
    private AnswerApi answerApi;
    @Autowired
    private UserApi userApi;
    @Autowired
    private ConfineApi confineApi;
    @Autowired
    private ProjectApi projectApi;

    protected abstract SubjectForm getConfig();

    @GetMapping
    public SubjectFormVO query(SdkContext ctx) {
        SubjectFormVO vo = new SubjectFormVO();
        ProjectDTO project = this.projectApi.query();
        vo.setStartTime(project.getStart());
        vo.setEndTime(project.getEnd());
        vo.setDesc(this.getConfig().getDesc());
        CreditsDTO credits = this.userApi.queryCredits(project.getCreditsType());
        vo.setUserCredits(credits.getCredits());
        vo.setCreditsUnit(credits.getCreditsTypeName());
        vo.setCredits(this.getConfig().getCredits());
        vo.setLastFreeNumber(this.confineApi.getLimit(ctx, this.getConfig().getFreeLimit()));
        vo.setLastJoinNumber(this.confineApi.getLimit(ctx, this.getConfig().getJoinLimit()));
        return vo;
    }

    @LogBuried(type={LogEnum.D403, LogEnum.D404})
    @PostMapping
    public AnswerStartResult start(SdkContext ctx) {
        AnswerStart request = new AnswerStart();
        request.setJoinLimit(request.getJoinLimit());
        request.setFreeLimit(request.getFreeLimit());
        request.setCredits(request.getCredits());
        request.setRandom(this.getConfig().getIsRandom());
        request.setNum(this.getConfig().getNum());
        request.setQuestions(this.getConfig().getQuestions());
        AnswerStartResult ret = this.answerApi.startRandom(request);
        UserDTO user = this.userApi.query();
        ret.setUserCredits(user.getCredits());
        ret.setLastFreeNumber(this.confineApi.getLimit(ctx, this.getConfig().getFreeLimit()));
        ret.setLastJoinNumber(this.confineApi.getLimit(ctx, this.getConfig().getJoinLimit()));
        return ret;
    }

    @PostMapping
    public SubmitResult submit(SdkContext ctx, @RequestBody SubmitAnswer request) {
        log.info("request:{}", (Object)JSONObject.toJSONString((Object)request));
        request.setQuestions(this.getConfig().getQuestions());
        return this.answerApi.submit(request);
    }

    @GetMapping
    public AnswerResult result(SdkContext ctx, @RequestParam Long examId) {
        return this.answerApi.result(examId, this.getConfig().getQuestions());
    }

    @BackendAction(name="\u7b54\u9898\u6570\u636e")
    public SdkPage<AnswerReportVO> report(SdkContext ctx, @RequestBody SdkPageQuery query) {
        return this.answerApi.findReportPage(ctx, query);
    }

    @BackendAction
    public void reportExport(SdkContext ctx, @RequestBody SdkPageQuery query) throws Exception {
        this.answerApi.findReportPageExport(ctx, query);
    }
}

