/*
 * Decompiled with CFR 0.152.
 */
package com.credits.activity.sdk.ctrl;

import com.alibaba.fastjson.JSONObject;
import com.credits.activity.sdk.SdkContext;
import com.credits.activity.sdk.common.KvApi;
import com.credits.activity.sdk.common.annotation.BackendAction;
import com.credits.activity.sdk.common.annotation.Crontab;
import com.credits.activity.sdk.common.dto.SdkPage;
import com.credits.activity.sdk.common.dto.SdkPageQuery;
import com.credits.activity.sdk.common.exception.SdkRuntimeException;
import com.credits.activity.sdk.common.utils.AssertUtils;
import com.credits.activity.sdk.component.game.RankApi;
import com.credits.activity.sdk.component.game.dto.RankDTO;
import com.credits.activity.sdk.component.game.dto.RankForm;
import com.credits.activity.sdk.component.game.dto.RankLotteryRequest;
import com.credits.activity.sdk.component.game.dto.RankPageQuery;
import com.credits.activity.sdk.component.game.dto.RankQuery;
import com.credits.activity.sdk.component.game.dto.RankQueryVO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class DefaultRankController {
    private static final Logger log = LoggerFactory.getLogger(DefaultRankController.class);
    @Autowired
    private RankApi rankApi;
    @Autowired
    private KvApi keyValueApi;

    protected abstract RankForm getConfig();

    @GetMapping
    public RankQueryVO query() {
        RankQueryVO vo = new RankQueryVO();
        vo.setRank(this.getConfig().getRank());
        vo.setRankType(this.getConfig().getRankType());
        vo.setPrize(this.getConfig().getPrize());
        return vo;
    }

    @PostMapping
    public List<RankDTO> top(SdkContext ctx, @RequestParam(value="limit") Long limit) {
        RankQuery query = new RankQuery();
        query.setStart(0L);
        query.setEnd(this.getConfig().getRankNum() == null ? 0L : this.getConfig().getRankNum());
        query.setSort(SdkPageQuery.SortType.valueOf(this.getConfig().getRankType()));
        return this.rankApi.getList(ctx, query);
    }

    @Crontab(value="1 0 * * * ?")
    public void auto(SdkContext ctx) {
        if ("auto".equals(this.getConfig().getOpenType()) && this.getConfig().getRank().booleanValue()) {
            log.info("autoOpen:{}", (Object)JSONObject.toJSONString((Object)ctx));
            RankLotteryRequest request = new RankLotteryRequest();
            request.setRankType(this.getConfig().getRankType());
            request.setRankPrize(this.getConfig().getPrize());
            try {
                this.rankApi.doPrize(ctx, request);
            }
            catch (Exception var4) {
                log.info("doPrize:{}", (Object)var4.getMessage());
            }
        }
    }

    @BackendAction
    public void open(SdkContext ctx) {
        if (!"manual".equals(this.getConfig().getOpenType())) {
            throw new SdkRuntimeException("\u4e0d\u662f\u4eba\u5de5\u5f00\u5956");
        }
        AssertUtils.isFalse(this.getConfig().getRank(), "\u672a\u5f00\u542f\u6392\u884c\u699c\u529f\u80fd");
        RankLotteryRequest request = new RankLotteryRequest();
        request.setRankType(this.getConfig().getRankType());
        request.setRankPrize(this.getConfig().getPrize());
        this.rankApi.doPrize(ctx, request);
    }

    @BackendAction
    public SdkPage<RankDTO> page(SdkContext ctx, @RequestBody RankPageQuery query) {
        return this.rankApi.getPage(ctx, query);
    }
}

