package cn.codeboxes.core.threadpool;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * created by liugq in 2024/09/13
 **/
@Configuration
@EnableConfigurationProperties(ExecutorServiceProperties.class)
public class ExecutorServiceConfig {

    @Bean
    @ConditionalOnMissingBean
    public ExecutorService executorService(ExecutorServiceProperties properties) {

        int corePoolSize = properties.getCorePoolSize();
        int maximumPoolSize = properties.getMaximumPoolSize();
        long keepAliveTime = properties.getKeepAliveTime();

        System.out.println("线程信息：" + corePoolSize + "----" + maximumPoolSize  + "----" + keepAliveTime);

        NamedThreadFactory threadFactory = new NamedThreadFactory("credits-executor");

        return new ThreadPoolExecutor(
                corePoolSize,
                maximumPoolSize,
                keepAliveTime,
                TimeUnit.SECONDS,
                new LinkedBlockingQueue<>(500), threadFactory); // 工作队列
    }
}

