/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.core.threadpool;

import cn.codeboxes.core.threadpool.ExecutorServiceProperties;
import cn.codeboxes.core.threadpool.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ExecutorServiceProperties.class})
public class ExecutorServiceConfig {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public ExecutorService executorService(ExecutorServiceProperties properties) {
        int corePoolSize = properties.getCorePoolSize();
        int maximumPoolSize = properties.getMaximumPoolSize();
        long keepAliveTime = properties.getKeepAliveTime();
        int queueSize = properties.getQueueSize();
        NamedThreadFactory threadFactory = new NamedThreadFactory("credits-executor");
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory);
        log.info("start thread pool coreSize:{} maxSize:{} queueSize:{}", new Object[]{corePoolSize, maximumPoolSize, queueSize});
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!executor.isShutdown()) {
                executor.shutdown();
                try {
                    if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                        executor.shutdownNow();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    executor.shutdownNow();
                }
            }
        }));
        return executor;
    }
}

