/*
 * Decompiled with CFR 0.152.
 */
package cn.codeboxes.credits.test.core.util;

import cn.codeboxes.credits.framework.common.enums.CommonStatusEnum;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.co.jemos.podam.api.PodamFactory;
import uk.co.jemos.podam.api.PodamFactoryImpl;

public class RandomUtils {
    private static final int RANDOM_STRING_LENGTH = 10;
    private static final int TINYINT_MAX = 127;
    private static final int RANDOM_DATE_MAX = 30;
    private static final int RANDOM_COLLECTION_LENGTH = 5;
    private static final PodamFactory PODAM_FACTORY = new PodamFactoryImpl();

    public static String randomString() {
        return RandomUtil.randomString((int)10);
    }

    public static Long randomLongId() {
        return RandomUtil.randomLong((long)0L, (long)Long.MAX_VALUE);
    }

    public static Integer randomInteger() {
        return RandomUtil.randomInt((int)0, (int)Integer.MAX_VALUE);
    }

    public static Date randomDate() {
        return RandomUtil.randomDay((int)0, (int)30);
    }

    public static LocalDateTime randomLocalDateTime() {
        return LocalDateTimeUtil.of((Date)RandomUtils.randomDate()).withNano(0);
    }

    public static Short randomShort() {
        return (short)RandomUtil.randomInt((int)0, (int)Short.MAX_VALUE);
    }

    public static <T> Set<T> randomSet(Class<T> clazz) {
        return Stream.iterate(0, i -> i).limit(RandomUtil.randomInt((int)1, (int)5)).map(i -> RandomUtils.randomPojo(clazz, new Consumer[0])).collect(Collectors.toSet());
    }

    public static Integer randomCommonStatus() {
        return ((CommonStatusEnum)RandomUtil.randomEle((Object[])CommonStatusEnum.values())).getStatus();
    }

    public static String randomEmail() {
        return RandomUtils.randomString() + "@qq.com";
    }

    public static String randomURL() {
        return "https://www.iocoder.cn/" + RandomUtils.randomString();
    }

    @SafeVarargs
    public static <T> T randomPojo(Class<T> clazz, Consumer<T> ... consumers) {
        Object pojo = PODAM_FACTORY.manufacturePojo(clazz, new Type[0]);
        if (ArrayUtil.isNotEmpty((Object[])consumers)) {
            Arrays.stream(consumers).forEach(consumer -> consumer.accept(pojo));
        }
        return (T)pojo;
    }

    @SafeVarargs
    public static <T> T randomPojo(Class<T> clazz, Type type, Consumer<T> ... consumers) {
        Object pojo = PODAM_FACTORY.manufacturePojo(clazz, new Type[]{type});
        if (ArrayUtil.isNotEmpty((Object[])consumers)) {
            Arrays.stream(consumers).forEach(consumer -> consumer.accept(pojo));
        }
        return (T)pojo;
    }

    @SafeVarargs
    public static <T> List<T> randomPojoList(Class<T> clazz, Consumer<T> ... consumers) {
        int size = RandomUtil.randomInt((int)1, (int)5);
        return Stream.iterate(0, i -> i).limit(size).map(o -> RandomUtils.randomPojo(clazz, consumers)).collect(Collectors.toList());
    }

    static {
        PODAM_FACTORY.getStrategy().addOrReplaceTypeManufacturer(String.class, (dataProviderStrategy, attributeMetadata, map) -> RandomUtils.randomString());
        PODAM_FACTORY.getStrategy().addOrReplaceTypeManufacturer(Integer.class, (dataProviderStrategy, attributeMetadata, map) -> {
            if ("status".equals(attributeMetadata.getAttributeName())) {
                return ((CommonStatusEnum)RandomUtil.randomEle((Object[])CommonStatusEnum.values())).getStatus();
            }
            if (StrUtil.endWithAnyIgnoreCase((CharSequence)attributeMetadata.getAttributeName(), (CharSequence[])new CharSequence[]{"type", "status", "category", "scope", "result"})) {
                return RandomUtil.randomInt((int)0, (int)128);
            }
            return RandomUtil.randomInt();
        });
        PODAM_FACTORY.getStrategy().addOrReplaceTypeManufacturer(LocalDateTime.class, (dataProviderStrategy, attributeMetadata, map) -> RandomUtils.randomLocalDateTime());
        PODAM_FACTORY.getStrategy().addOrReplaceTypeManufacturer(Boolean.class, (dataProviderStrategy, attributeMetadata, map) -> {
            if ("deleted".equals(attributeMetadata.getAttributeName())) {
                return false;
            }
            return RandomUtil.randomBoolean();
        });
    }
}

