/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.client;

import com.alibaba.fastjson.JSON;
import com.iflytek.msp.cpdb.lfasr.client.LfasrClient;
import com.iflytek.msp.cpdb.lfasr.exception.ConfigException;
import com.iflytek.msp.cpdb.lfasr.exception.LfasrException;
import com.iflytek.msp.cpdb.lfasr.file.LocalPersistenceFile;
import com.iflytek.msp.cpdb.lfasr.model.LfasrType;
import com.iflytek.msp.cpdb.lfasr.model.Message;
import com.iflytek.msp.cpdb.lfasr.model.Signature;
import com.iflytek.msp.cpdb.lfasr.model.UploadParams;
import com.iflytek.msp.cpdb.lfasr.util.FileUtil;
import com.iflytek.msp.cpdb.lfasr.util.PropConfig;
import com.iflytek.msp.cpdb.lfasr.util.StringUtil;
import com.iflytek.msp.cpdb.lfasr.util.VersionUtil;
import com.iflytek.msp.cpdb.lfasr.worker.HttpWorker;
import com.iflytek.msp.cpdb.lfasr.worker.ResumeWorker;
import com.iflytek.msp.cpdb.lfasr.worker.UploadWorker;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LfasrClientImp
implements LfasrClient {
    private static final Logger LOGGER;
    private static String POPERTIES_FILEPATH;
    private static String POPERTIES_APP_ID_TG;
    private static String POPERTIES_SERCET_KEY_TG;
    private static String POPERTIES_LFASR_HOST_TG;
    private static String POPERTIES_FILE_PIECE_SIZE_TG;
    private static String POPERTIES_STORE_PATH_TG;
    private static String SERV_APP_ID_VAL;
    private static String SERV_SECRET_KEY_VAL;
    public static String SERV_LFASR_HOST_VAL;
    private static int SERV_FILE_PIECE_SIZE_VAL;
    public static String SERV_STORE_PATH_VAL;
    private static String err_msg;

    static {
        block13: {
            Map<Object, Object> poperties;
            block12: {
                LOGGER = Logger.getLogger(LfasrClientImp.class);
                POPERTIES_FILEPATH = "config.properties";
                POPERTIES_APP_ID_TG = "app_id";
                POPERTIES_SERCET_KEY_TG = "secret_key";
                POPERTIES_LFASR_HOST_TG = "lfasr_host";
                POPERTIES_FILE_PIECE_SIZE_TG = "file_piece_size";
                POPERTIES_STORE_PATH_TG = "store_path";
                SERV_APP_ID_VAL = "";
                SERV_SECRET_KEY_VAL = "";
                SERV_LFASR_HOST_VAL = "";
                SERV_FILE_PIECE_SIZE_VAL = 262144;
                SERV_STORE_PATH_VAL = "";
                err_msg = null;
                poperties = new HashMap();
                try {
                    poperties = PropConfig.LoadPoperties(POPERTIES_FILEPATH);
                }
                catch (ConfigException e) {
                    err_msg = "{\"ok\":\"-1\", \"err_no\":\"26100\", \"failed\":\"\u8f6c\u5199\u914d\u7f6e\u6587\u4ef6\u9519\u8bef!\", \"data\":\"\"}";
                }
                SERV_APP_ID_VAL = (String)poperties.get(POPERTIES_APP_ID_TG);
                SERV_SECRET_KEY_VAL = (String)poperties.get(POPERTIES_SERCET_KEY_TG);
                if ((StringUtil.isEmpty(SERV_APP_ID_VAL) || StringUtil.isEmpty(SERV_SECRET_KEY_VAL)) && StringUtil.isEmpty(err_msg)) {
                    err_msg = "{\"ok\":\"-1\", \"err_no\":\"26101\", \"failed\":\"\u8f6c\u5199\u914d\u7f6e\u6587\u4ef6app_id/secret_key\u4e3a\u7a7a!\", \"data\":\"\"}";
                }
                if (StringUtil.isEmpty(SERV_LFASR_HOST_VAL = (String)poperties.get(POPERTIES_LFASR_HOST_TG)) && StringUtil.isEmpty(err_msg)) {
                    err_msg = "{\"ok\":\"-1\", \"err_no\":\"26102\", \"failed\":\"\u8f6c\u5199\u914d\u7f6e\u6587\u4ef6lfasr_host\u9519\u8bef!\", \"data\":\"\"}";
                }
                try {
                    SERV_FILE_PIECE_SIZE_VAL = Integer.parseInt((String)poperties.get(POPERTIES_FILE_PIECE_SIZE_TG));
                }
                catch (NumberFormatException e) {
                    if (!StringUtil.isEmpty(err_msg)) break block12;
                    err_msg = "{\"ok\":\"-1\", \"err_no\":\"26103\", \"failed\":\"\u8f6c\u5199\u914d\u7f6e\u6587\u4ef6file_piece_size\u9519\u8bef!\", \"data\":\"\"}";
                }
            }
            if (SERV_FILE_PIECE_SIZE_VAL < 131072 || SERV_FILE_PIECE_SIZE_VAL > 0xA00000) {
                err_msg = "{\"ok\":\"-1\", \"err_no\":\"26104\", \"failed\":\"\u8f6c\u5199\u914d\u7f6e\u6587\u4ef6file_piece_size\u5efa\u8bae\u8bbe\u7f6e128K~10M\u4e4b\u95f4!\", \"data\":\"\"}";
            }
            if (StringUtil.isEmpty(SERV_STORE_PATH_VAL = (String)poperties.get(POPERTIES_STORE_PATH_TG))) {
                if (StringUtil.isEmpty(err_msg)) {
                    err_msg = "{\"ok\":\"-1\", \"err_no\":\"26105\", \"failed\":\"\u8f6c\u5199\u914d\u7f6e\u6587\u4ef6store_path\u9519\u8bef\uff0c\u6216\u76ee\u5f55\u4e0d\u53ef\u8bfb\u5199!\", \"data\":\"\"}";
                }
            } else {
                String file_test = String.valueOf(SERV_STORE_PATH_VAL) + "/test.dat";
                try {
                    LocalPersistenceFile.writeNIO(file_test, "test");
                    LocalPersistenceFile.deleteFile(new File(file_test));
                }
                catch (LfasrException e) {
                    if (!StringUtil.isEmpty(err_msg)) break block13;
                    err_msg = "{\"ok\":\"-1\", \"err_no\":\"26105\", \"failed\":\"\u8f6c\u5199\u914d\u7f6e\u6587\u4ef6store_path\u9519\u8bef\uff0c\u6216\u76ee\u5f55\u4e0d\u53ef\u8bfb\u5199!\", \"data\":\"\"}";
                }
            }
        }
    }

    public LfasrClientImp() throws LfasrException {
        if (!StringUtil.isEmpty(err_msg)) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", err_msg));
            throw new LfasrException(err_msg);
        }
    }

    public LfasrClientImp(String app_id, String secret_key) throws LfasrException {
        if (StringUtil.isEmpty(app_id) || StringUtil.isEmpty(secret_key)) {
            err_msg = "{\"ok\":\"-1\", \"err_no\":\"26101\", \"failed\":\"\u8f6c\u5199\u914d\u7f6e\u6587\u4ef6app_id/secret_key\u4e3a\u7a7a!\", \"data\":\"\"}";
        }
        SERV_APP_ID_VAL = app_id;
        SERV_SECRET_KEY_VAL = secret_key;
        if (!StringUtil.isEmpty(err_msg)) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", err_msg));
            throw new LfasrException(err_msg);
        }
    }

    public static LfasrClientImp initLfasrClient() throws LfasrException {
        return new LfasrClientImp();
    }

    public static LfasrClientImp initLfasrClient(String app_id, String secret_key) throws LfasrException {
        return new LfasrClientImp(app_id, secret_key);
    }

    @Override
    public Message lfasrUpload(String local_file, LfasrType lfasr_type) throws LfasrException {
        return this.lfasrUpload(local_file, lfasr_type, null);
    }

    @Override
    public Message lfasrUpload(String local_file, LfasrType lfasr_type, HashMap<String, String> params) throws LfasrException {
        boolean isExist = FileUtil.isExist(local_file);
        if (!isExist) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26201\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}"));
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26201\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}");
        }
        boolean isEmpty = FileUtil.isEmpty(local_file);
        if (isEmpty) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26201\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}"));
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26201\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}");
        }
        if (lfasr_type == null) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26202\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!\", \"data\":\"\"}"));
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26202\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!\", \"data\":\"\"}");
        }
        Signature signature = null;
        try {
            signature = new Signature(SERV_APP_ID_VAL, SERV_SECRET_KEY_VAL);
        }
        catch (Exception e) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26203\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}"));
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26203\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}");
        }
        UploadWorker uw = new UploadWorker(signature, new File(local_file), lfasr_type, SERV_FILE_PIECE_SIZE_VAL, params);
        return uw.upload();
    }

    @Override
    public void lfasrResume() throws LfasrException {
        ResumeWorker rw = new ResumeWorker();
        rw.upload();
    }

    @Override
    public Message lfasrGetVersion() throws LfasrException {
        try {
            UploadParams params = new UploadParams();
            params.setSignature(new Signature(SERV_APP_ID_VAL, SERV_SECRET_KEY_VAL));
            params.setClientVersion(VersionUtil.GetVersion());
            String result = new HttpWorker().getVersion(params);
            Message message = null;
            try {
                message = JSON.parseObject(result, Message.class);
                return message;
            }
            catch (Exception e) {
                LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26501\", \"failed\":\"\u8f6c\u5199\u83b7\u53d6\u7248\u672c\u53f7\u63a5\u53e3\u9519\u8bef!\", \"data\":\"\"}"));
                throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26501\", \"failed\":\"\u8f6c\u5199\u83b7\u53d6\u7248\u672c\u53f7\u63a5\u53e3\u9519\u8bef!\", \"data\":\"\"}");
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26203\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}"));
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26203\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}");
        }
    }

    @Override
    public Message lfasrGetProgress(String task_id) throws LfasrException {
        try {
            UploadParams params = new UploadParams();
            params.setSignature(new Signature(SERV_APP_ID_VAL, SERV_SECRET_KEY_VAL));
            params.setTaskId(task_id);
            String result = new HttpWorker().getProgress(params);
            Message message = null;
            try {
                message = JSON.parseObject(result, Message.class);
                return message;
            }
            catch (Exception e) {
                LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26505\", \"failed\":\"\u8f6c\u5199\u83b7\u53d6\u8fdb\u5ea6\u63a5\u53e3\u9519\u8bef!\", \"data\":\"\"}"));
                throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26505\", \"failed\":\"\u8f6c\u5199\u83b7\u53d6\u8fdb\u5ea6\u63a5\u53e3\u9519\u8bef!\", \"data\":\"\"}");
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26203\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}"));
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26203\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}");
        }
    }

    @Override
    public Message lfasrGetResult(String task_id) throws LfasrException {
        try {
            UploadParams params = new UploadParams();
            params.setSignature(new Signature(SERV_APP_ID_VAL, SERV_SECRET_KEY_VAL));
            params.setTaskId(task_id);
            String result = new HttpWorker().getResult(params);
            Message message = null;
            try {
                message = JSON.parseObject(result, Message.class);
                return message;
            }
            catch (Exception e) {
                LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26506\", \"failed\":\"\u8f6c\u5199\u83b7\u53d6\u7ed3\u679c\u63a5\u53e3\u9519\u8bef!\", \"data\":\"\"}"));
                throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26506\", \"failed\":\"\u8f6c\u5199\u83b7\u53d6\u7ed3\u679c\u63a5\u53e3\u9519\u8bef!\", \"data\":\"\"}");
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "LfasrClientImp", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26203\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}"));
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26203\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u5ba2\u6237\u7aef\u751f\u6210\u7b7e\u540d\u9519\u8bef!\", \"data\":\"\"}");
        }
    }
}

