/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.event;

import com.alibaba.fastjson.JSON;
import com.iflytek.msp.cpdb.lfasr.client.LfasrClientImp;
import com.iflytek.msp.cpdb.lfasr.event.Event;
import com.iflytek.msp.cpdb.lfasr.event.EventQueue;
import com.iflytek.msp.cpdb.lfasr.exception.LfasrException;
import com.iflytek.msp.cpdb.lfasr.file.LocalPersistenceFile;
import com.iflytek.msp.cpdb.lfasr.model.EventType;
import com.iflytek.msp.cpdb.lfasr.model.Message;
import com.iflytek.msp.cpdb.lfasr.model.UploadParams;
import com.iflytek.msp.cpdb.lfasr.worker.HttpWorker;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class EventHandler {
    private static final Logger LOGGER = Logger.getLogger(EventHandler.class);
    private UploadParams upParams;
    private long file_piece_size;
    private boolean is_resume = false;
    private EventQueue<Event> queue;
    private HashMap<String, Boolean> slice_hm = new HashMap();
    private CountDownLatch latch = new CountDownLatch(1);
    private ExecutorService exec;
    private int threadNum = 10;

    public EventHandler(UploadParams upParams, long file_piece_size, boolean is_resume) {
        this.upParams = upParams;
        this.file_piece_size = file_piece_size;
        this.is_resume = is_resume;
        this.queue = new EventQueue();
        this.exec = Executors.newFixedThreadPool(this.threadNum);
        this.start();
    }

    public void start() {
        int i = 0;
        while (i < this.threadNum) {
            this.exec.execute(new ProcessorThread());
            ++i;
        }
    }

    public void addEvent(Event event) {
        try {
            this.queue.put(event);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void modifySliceHM(String slice_id, boolean bool) {
        this.slice_hm.put(slice_id, bool);
    }

    public boolean isSendAll() {
        boolean isSend = true;
        if (this.slice_hm == null) {
            return isSend;
        }
        int sendNum = 0;
        for (Map.Entry<String, Boolean> entry : this.slice_hm.entrySet()) {
            if (((Object)entry.getValue()).toString().equalsIgnoreCase("false")) {
                isSend = false;
                continue;
            }
            ++sendNum;
        }
        LOGGER.info(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "EventHandler", "", "", "(-1) ms", "upload file " + sendNum + "/" + this.slice_hm.size()));
        return isSend;
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public void shutdownNow() {
        this.exec.shutdownNow();
    }

    public class ProcessorThread
    implements Runnable {
        @Override
        public void run() {
            while (true) {
                String result;
                HttpWorker worker2;
                Event event = null;
                try {
                    event = (Event)EventHandler.this.queue.take();
                }
                catch (InterruptedException e) {
                    break;
                }
                if (event.getType().getValue() == EventType.LFASR_FILE_DATA_CONTENT.getValue()) {
                    worker2 = new HttpWorker();
                    result = worker2.handle(event);
                    String slice_id = event.getFileSlice().getSliceID();
                    Message responseObj = null;
                    try {
                        responseObj = JSON.parseObject(result, Message.class);
                    }
                    catch (Exception e) {
                        LOGGER.warn(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "EventHandler", event.getParams().getTaskId(), "", "(-1) ms", "slice_id:" + slice_id + " send fail...try again..."));
                        EventHandler.this.addEvent(event);
                        continue;
                    }
                    if (responseObj.getOk() == 0) {
                        try {
                            LocalPersistenceFile.writeNIO(String.valueOf(LfasrClientImp.SERV_STORE_PATH_VAL) + "/" + EventHandler.this.upParams.getTaskId() + ".dat", slice_id);
                            EventHandler.this.modifySliceHM(slice_id, true);
                        }
                        catch (LfasrException e) {
                            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "EventHandler", event.getParams().getTaskId(), "", "(-1) ms", "write meta info to " + LfasrClientImp.SERV_STORE_PATH_VAL + "/" + EventHandler.this.upParams.getTaskId() + ".dat" + " error"), e);
                        }
                        LOGGER.debug(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "EventHandler", event.getParams().getTaskId(), "", "(-1) ms", "upload slice send success.file:" + EventHandler.this.upParams.getFile().getAbsolutePath() + ", slice_id:" + slice_id));
                        continue;
                    }
                    EventHandler.this.addEvent(event);
                    LOGGER.warn(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "EventHandler", event.getParams().getTaskId(), "", "(-1) ms", "slice_id:" + slice_id + " send fail...try again..."));
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException worker2) {
                    // empty catch block
                }
                worker2 = new HttpWorker();
                result = worker2.meger(event);
                Message responseObj = null;
                try {
                    responseObj = JSON.parseObject(result, Message.class);
                }
                catch (Exception e) {
                    EventHandler.this.addEvent(event);
                    LOGGER.warn(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "EventHandler", event.getParams().getTaskId(), "", "(-1) ms", "send meger fail...try again...."));
                    continue;
                }
                if (responseObj.getOk() == 0) {
                    LocalPersistenceFile.deleteFile(new File(String.valueOf(LfasrClientImp.SERV_STORE_PATH_VAL) + "/" + EventHandler.this.upParams.getTaskId() + ".dat"));
                    LOGGER.info(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "EventHandler", event.getParams().getTaskId(), "", "(-1) ms", "send meger success"));
                    EventHandler.this.latch.countDown();
                    break;
                }
                EventHandler.this.addEvent(event);
                LOGGER.warn(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "EventHandler", event.getParams().getTaskId(), "", "(-1) ms", "send meger fail...try again...."));
            }
        }
    }
}

