/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.file;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.flac.FlacFileReader;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.audio.mp3.MP3File;

public class AudioLength {
    public static void main(String[] args) {
        String file = "E:\\SRC_SVN\\Y_cpdb\\Trunk\\Development\\Source\\cpdb-lfasr\\lfasr-test\\test\\25.wav";
        int i = 0;
        while (i < 100000) {
            double len = AudioLength.getLength(file);
            System.out.println(String.valueOf(i) + " " + len);
            ++i;
        }
    }

    public static double getLength(String file) {
        try {
            String ext;
            int i = file.lastIndexOf(".");
            switch (ext = file.substring(i + 1)) {
                case "mp3": {
                    return AudioLength.mp3File(file);
                }
                case "flac": {
                    return AudioLength.flacFile(file);
                }
                case "wav": {
                    return AudioLength.wavFile(file);
                }
            }
            return -1.0;
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public static double mp3File(String file) {
        try {
            File fileMP3 = new File(file);
            MP3File f = (MP3File)AudioFileIO.read(fileMP3);
            MP3AudioHeader audioHeader = (MP3AudioHeader)f.getAudioHeader();
            return audioHeader.getTrackLength();
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    public static double flacFile(String file) {
        try {
            File fileFLAC = new File(file);
            FlacFileReader f = new FlacFileReader();
            AudioFile af = f.read(fileFLAC);
            AudioHeader audioHeader = af.getAudioHeader();
            return audioHeader.getTrackLength();
        }
        catch (Exception e) {
            return -1.0;
        }
    }

    /*
     * Loose catch block
     */
    public static double wavFile(String file) {
        File fileWav = null;
        Line clip = null;
        AudioInputStream ais = null;
        fileWav = new File(file);
        clip = AudioSystem.getClip();
        ais = AudioSystem.getAudioInputStream(fileWav);
        clip.open(ais);
        double d = Math.rint((double)clip.getMicrosecondLength() / 1000000.0);
        try {
            clip.close();
            ais.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return d;
        catch (Exception e) {
            try {
                clip.close();
                ais.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -1.0;
            catch (Throwable throwable) {
                try {
                    clip.close();
                    ais.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

