/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.file;

import com.iflytek.msp.cpdb.lfasr.exception.LfasrException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.List;
import org.apache.http.util.TextUtils;
import org.apache.log4j.Logger;

public class MergeFile {
    private static final Logger LOGGER = Logger.getLogger(MergeFile.class);

    public static boolean mergeFiles(List<String> fpaths, String resultPath) throws LfasrException {
        if (fpaths == null || fpaths.size() < 1 || TextUtils.isEmpty(resultPath)) {
            return false;
        }
        if (fpaths.size() == 1) {
            return new File(fpaths.get(0)).renameTo(new File(resultPath));
        }
        File[] files = new File[fpaths.size()];
        int i = 0;
        while (i < fpaths.size()) {
            files[i] = new File(fpaths.get(i));
            if (TextUtils.isEmpty(fpaths.get(i)) || !files[i].exists() || !files[i].isFile()) {
                return false;
            }
            ++i;
        }
        File resultFile = new File(resultPath);
        try {
            FileChannel resultFileChannel = new FileOutputStream(resultFile, true).getChannel();
            int i2 = 0;
            while (i2 < fpaths.size()) {
                FileChannel blk = new FileInputStream(files[i2]).getChannel();
                resultFileChannel.transferFrom(blk, resultFileChannel.size(), blk.size());
                blk.close();
                ++i2;
            }
            resultFileChannel.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "MergeFile", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26201\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}"), e);
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26201\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}");
        }
        catch (IOException e) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "MergeFile", "", "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26201\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}"), e);
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26201\", \"failed\":\"\u8f6c\u5199\u53c2\u6570\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u6216\u6587\u4ef6\u4e0d\u5b58\u5728!\", \"data\":\"\"}");
        }
        return true;
    }
}

