/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.model;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public enum LfasrType {
    LFASR_STANDARD_RECORDED_AUDIO("\u6807\u51c6\u7248-\u5df2\u5f55\u5236\u97f3\u9891", "wav,flac,opus,mp3,m4a", 0),
    LFASR_TELEPHONY_RECORDED_AUDIO("\u7535\u8bdd\u4e13\u7528\u7248-\u5df2\u5f55\u5236\u97f3\u9891", "wav,flac,mp3", 2);

    private String name;
    private int value;
    private Map<String, Boolean> supportedAudiosMap = new HashMap<String, Boolean>();

    private LfasrType(String name, String supportedAudios, int value) {
        String[] supportedExts;
        this.name = name;
        this.value = value;
        String[] stringArray = supportedExts = supportedAudios.split(",");
        int n2 = supportedExts.length;
        int n3 = 0;
        while (n3 < n2) {
            String ext = stringArray[n3];
            this.supportedAudiosMap.put(ext, true);
            ++n3;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isSupportedAudios(File file) {
        String fileName = file.getName();
        try {
            int i = fileName.lastIndexOf(".");
            String ext = fileName.substring(i + 1);
            Boolean B = this.supportedAudiosMap.get(ext.toLowerCase());
            return B != null ? B : false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

