/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.model;

import com.iflytek.msp.cpdb.lfasr.util.Base64Encoder;
import com.iflytek.msp.cpdb.lfasr.util.Md5Tool;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Signature {
    private String app_id;
    private String secret_key;
    private String signa;
    private String ts;

    public Signature(String app_id, String secret_key) throws SignatureException {
        this.app_id = app_id;
        this.secret_key = secret_key;
        this.ts = String.valueOf(new Date().getTime() / 1000L);
        this.signa = Signature.HmacSHA1Encrypt(Md5Tool.MD5(String.valueOf(app_id) + this.ts), secret_key);
    }

    public Signature(String app_id, String secret_key, String signa, String ts) throws SignatureException {
        this.app_id = app_id;
        this.secret_key = secret_key;
        this.ts = ts;
        this.signa = signa;
    }

    private static String HmacSHA1Encrypt(String encryptText, String encryptKey) throws SignatureException {
        byte[] rawHmac = null;
        try {
            byte[] data = encryptKey.getBytes("UTF-8");
            SecretKeySpec secretKey = new SecretKeySpec(data, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
            byte[] text = encryptText.getBytes("UTF-8");
            rawHmac = mac.doFinal(text);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("InvalidKeyException:" + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException("NoSuchAlgorithmException:" + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException("UnsupportedEncodingException:" + e.getMessage());
        }
        Base64Encoder encoder = new Base64Encoder();
        String oauth = encoder.encode(rawHmac);
        return oauth;
    }

    public String getAppID() {
        return this.app_id;
    }

    public void setAppID(String app_id) {
        this.app_id = app_id;
    }

    public String getSecretKey() {
        return this.secret_key;
    }

    public void setSecretKey(String secret_key) {
        this.secret_key = secret_key;
    }

    public String getSigna() {
        return this.signa;
    }

    public void setSigna(String signa) {
        this.signa = signa;
    }

    public String getTs() {
        return this.ts;
    }

    public void setTs(String ts) {
        this.ts = ts;
    }
}

