/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.worker;

import com.iflytek.msp.cpdb.lfasr.client.LfasrClientImp;
import com.iflytek.msp.cpdb.lfasr.event.Event;
import com.iflytek.msp.cpdb.lfasr.http.HttpUtil;
import com.iflytek.msp.cpdb.lfasr.model.FileSlice;
import com.iflytek.msp.cpdb.lfasr.model.UploadParams;
import java.util.HashMap;
import java.util.Map;

public class HttpWorker {
    private static String url_prepare = String.valueOf(LfasrClientImp.SERV_LFASR_HOST_VAL) + "/" + "prepare";
    private static String url_upload = String.valueOf(LfasrClientImp.SERV_LFASR_HOST_VAL) + "/" + "upload";
    private static String url_meger = String.valueOf(LfasrClientImp.SERV_LFASR_HOST_VAL) + "/" + "merge";
    private static String url_result = String.valueOf(LfasrClientImp.SERV_LFASR_HOST_VAL) + "/" + "getResult";
    private static String url_progress = String.valueOf(LfasrClientImp.SERV_LFASR_HOST_VAL) + "/" + "getProgress";
    private static String url_version = String.valueOf(LfasrClientImp.SERV_LFASR_HOST_VAL) + "/" + "getVersion";

    public String prepare(UploadParams upParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", upParams.getSignature().getAppID());
        params.put("secret_key", upParams.getSignature().getSecretKey());
        params.put("signa", upParams.getSignature().getSigna());
        params.put("ts", upParams.getSignature().getTs());
        params.put("file_len", String.valueOf(upParams.getFile().length()));
        params.put("file_name", upParams.getFile().getName());
        params.put("lfasr_type", String.valueOf(upParams.getLfasrType().getValue()));
        params.put("slice_num", String.valueOf(upParams.getSliceNum()));
        params.put("client_version", upParams.getClientVersion());
        params.put("check_length", "" + upParams.getCheckLength());
        HashMap<String, String> p = upParams.getParams();
        if (p != null) {
            for (Map.Entry<String, String> entry : p.entrySet()) {
                params.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return HttpUtil.post(url_prepare, params);
    }

    public String handle(Event event) {
        FileSlice fileSlice = event.getFileSlice();
        UploadParams params = event.getParams();
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("app_id", params.getSignature().getAppID());
        hm.put("signa", params.getSignature().getSigna());
        hm.put("ts", params.getSignature().getTs());
        hm.put("slice_id", fileSlice.getSliceID());
        hm.put("task_id", params.getTaskId());
        return HttpUtil.postMulti(url_upload, hm, fileSlice.getBody());
    }

    public String meger(Event event) {
        UploadParams params = event.getParams();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_id", params.getSignature().getAppID());
        map.put("signa", params.getSignature().getSigna());
        map.put("ts", params.getSignature().getTs());
        map.put("task_id", params.getTaskId());
        map.put("file_name", params.getFile().getName());
        return HttpUtil.post(url_meger, map);
    }

    public String getResult(UploadParams params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_id", params.getSignature().getAppID());
        map.put("signa", params.getSignature().getSigna());
        map.put("ts", params.getSignature().getTs());
        map.put("task_id", params.getTaskId());
        return HttpUtil.post(url_result, map);
    }

    public String getProgress(UploadParams params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_id", params.getSignature().getAppID());
        map.put("signa", params.getSignature().getSigna());
        map.put("ts", params.getSignature().getTs());
        map.put("task_id", params.getTaskId());
        return HttpUtil.post(url_progress, map);
    }

    public String getVersion(UploadParams params) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("app_id", params.getSignature().getAppID());
        map.put("signa", params.getSignature().getSigna());
        map.put("ts", params.getSignature().getTs());
        map.put("client_version", params.getClientVersion());
        return HttpUtil.post(url_version, map);
    }
}

