/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.worker;

import com.alibaba.fastjson.JSON;
import com.iflytek.msp.cpdb.lfasr.client.LfasrClientImp;
import com.iflytek.msp.cpdb.lfasr.event.Event;
import com.iflytek.msp.cpdb.lfasr.exception.LfasrException;
import com.iflytek.msp.cpdb.lfasr.file.ChannelFileReader;
import com.iflytek.msp.cpdb.lfasr.file.LocalPersistenceFile;
import com.iflytek.msp.cpdb.lfasr.model.EventType;
import com.iflytek.msp.cpdb.lfasr.model.LfasrType;
import com.iflytek.msp.cpdb.lfasr.model.LocalPersistenceMeta;
import com.iflytek.msp.cpdb.lfasr.model.Signature;
import com.iflytek.msp.cpdb.lfasr.model.UploadParams;
import com.iflytek.msp.cpdb.lfasr.worker.SliceWorker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class ResumeWorker {
    private static final Logger LOGGER = Logger.getLogger(ResumeWorker.class);

    public void upload() throws LfasrException {
        List<Object> fileList = new ArrayList();
        fileList = LocalPersistenceFile.getFileList(String.valueOf(LfasrClientImp.SERV_STORE_PATH_VAL) + "/");
        try {
            int i = 0;
            while (i < fileList.size()) {
                String fileName = ((File)fileList.get(i)).toString();
                try {
                    String app_id = "";
                    String secret_key = "";
                    String signa = "";
                    String ts = "";
                    LfasrType lfasr_type = null;
                    int file_piece_size = 0;
                    String task_id = "";
                    File file = null;
                    HashMap<String, String> params = null;
                    HashMap<String, String> hm = new HashMap<String, String>();
                    FileReader reader = new FileReader(fileName);
                    BufferedReader br = new BufferedReader(reader);
                    String str = null;
                    int line = 1;
                    while ((str = br.readLine()) != null) {
                        if (line == 1) {
                            LocalPersistenceMeta lpm = JSON.parseObject(str, LocalPersistenceMeta.class);
                            app_id = lpm.getAppId();
                            secret_key = lpm.getSecretKey();
                            signa = lpm.getSigna();
                            ts = lpm.getTs();
                            lfasr_type = lpm.getLfasrType() == 0 ? LfasrType.LFASR_STANDARD_RECORDED_AUDIO : LfasrType.LFASR_TELEPHONY_RECORDED_AUDIO;
                            file_piece_size = lpm.getFilePieceSize();
                            task_id = lpm.getTaskId();
                            file = new File(lpm.getFile());
                            params = lpm.getParams();
                        } else {
                            hm.put(str, "");
                        }
                        ++line;
                    }
                    br.close();
                    reader.close();
                    UploadParams upParams = new UploadParams(new Signature(app_id, secret_key, signa, ts), file, lfasr_type, params, task_id);
                    if (!upParams.getLfasrType().isSupportedAudios(upParams.getFile())) {
                        LOGGER.warn(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "ResumeWorker", upParams.getTaskId(), "", "(-1) ms", "resume file:" + file.getName() + " type is wrong, maybe file was changed, you can delete it and upload a new one"));
                        throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26303\", \"failed\":\"\u8f6c\u5199\u6062\u590d\u65ad\u70b9\u7eed\u4f20\u6d41\u7a0b\u9519\u8bef,\u8bf7\u89c1\u65e5\u5fd7\uff01\", \"data\":\"\"}");
                    }
                    try {
                        ChannelFileReader fr = new ChannelFileReader(upParams.getFile(), file_piece_size);
                        long fileLen = fr.getFileLength();
                        if (fileLen >= 524288000L) {
                            LOGGER.warn(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "ResumeWorker", upParams.getTaskId(), "", "(-1) ms", "resume file:" + file.getName() + " size is too larger, maybe file was changed, you can delete it and upload a new one "));
                            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26303\", \"failed\":\"\u8f6c\u5199\u6062\u590d\u65ad\u70b9\u7eed\u4f20\u6d41\u7a0b\u9519\u8bef,\u8bf7\u89c1\u65e5\u5fd7\uff01\", \"data\":\"\"}");
                        }
                        SliceWorker sw = new SliceWorker(upParams, file_piece_size, true, hm);
                        sw.sliceFile(fr);
                        fr.close();
                        boolean isSend = sw.getEventHandler().isSendAll();
                        while (!isSend) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            isSend = sw.getEventHandler().isSendAll();
                        }
                        Event event = new Event(EventType.LFASR_FILE_DATA_END, upParams);
                        sw.getEventHandler().addEvent(event);
                        sw.getEventHandler().await();
                        sw.getEventHandler().shutdownNow();
                    }
                    catch (Exception e) {}
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "ResumeWorker", "", "", "(-1) ms", "resume file:" + fileName + " read error, maybe file was changed, you can delete it and upload a new one"));
                    throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26303\", \"failed\":\"\u8f6c\u5199\u6062\u590d\u65ad\u70b9\u7eed\u4f20\u6d41\u7a0b\u9519\u8bef,\u8bf7\u89c1\u65e5\u5fd7\uff01\", \"data\":\"\"}");
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26303\", \"failed\":\"\u8f6c\u5199\u6062\u590d\u65ad\u70b9\u7eed\u4f20\u6d41\u7a0b\u9519\u8bef,\u8bf7\u89c1\u65e5\u5fd7\uff01\", \"data\":\"\"}");
        }
    }
}

