/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.worker;

import com.iflytek.msp.cpdb.lfasr.file.ChannelFileReader;
import com.iflytek.msp.cpdb.lfasr.model.UploadParams;
import com.iflytek.msp.cpdb.lfasr.worker.SliceWorker;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class UploadThread
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(UploadThread.class);
    private UploadParams params;
    private int file_piece_size;

    public UploadThread(UploadParams params, int file_piece_size) {
        this.params = params;
        this.file_piece_size = file_piece_size;
    }

    @Override
    public void run() {
        try {
            ChannelFileReader fr = new ChannelFileReader(this.params.getFile(), this.file_piece_size);
            SliceWorker sw = new SliceWorker(this.params, this.file_piece_size, false, new HashMap<String, String>());
            sw.sliceFile(fr);
            fr.close();
            boolean isSend = sw.getEventHandler().isSendAll();
            while (!isSend) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                isSend = sw.getEventHandler().isSendAll();
            }
            LOGGER.info(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadThread", this.params.getTaskId(), "", "(-1) ms", "upload file send success, file:" + this.params.getFile().getAbsolutePath() + ", task_id:" + this.params.getTaskId()));
            sw.setFileEnd();
            sw.getEventHandler().await();
            sw.getEventHandler().shutdownNow();
        }
        catch (Exception e) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadThread", this.params.getTaskId(), "", "(-1) ms", "upload file send error, file:" + this.params.getFile().getAbsolutePath() + ", task_id:" + this.params.getTaskId()), e);
        }
    }
}

