/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.msp.cpdb.lfasr.worker;

import com.alibaba.fastjson.JSON;
import com.iflytek.msp.cpdb.lfasr.client.LfasrClientImp;
import com.iflytek.msp.cpdb.lfasr.exception.LfasrException;
import com.iflytek.msp.cpdb.lfasr.file.AudioLength;
import com.iflytek.msp.cpdb.lfasr.file.ChannelFileReader;
import com.iflytek.msp.cpdb.lfasr.file.LocalPersistenceFile;
import com.iflytek.msp.cpdb.lfasr.model.LfasrType;
import com.iflytek.msp.cpdb.lfasr.model.LocalPersistenceMeta;
import com.iflytek.msp.cpdb.lfasr.model.Message;
import com.iflytek.msp.cpdb.lfasr.model.Signature;
import com.iflytek.msp.cpdb.lfasr.model.UploadParams;
import com.iflytek.msp.cpdb.lfasr.util.VersionUtil;
import com.iflytek.msp.cpdb.lfasr.worker.HttpWorker;
import com.iflytek.msp.cpdb.lfasr.worker.UploadThread;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class UploadWorker {
    public static final long FILE_UPLOAD_MAXSIZE = 524288000L;
    private UploadParams upParams;
    private int file_piece_size;
    private static final Logger LOGGER = Logger.getLogger(UploadWorker.class);

    public UploadWorker(Signature signature, File file, LfasrType lfasr_type, int file_piece_size, HashMap<String, String> params) {
        long file_len = file.length();
        int flag = (int)file_len % file_piece_size;
        int slice_num = flag == 0 ? (int)file_len / file_piece_size : (int)file_len / file_piece_size + 1;
        this.upParams = new UploadParams(signature, file, lfasr_type, params);
        this.upParams.setSliceNum(slice_num);
        this.upParams.setClientVersion(VersionUtil.GetVersion());
        this.file_piece_size = file_piece_size;
    }

    public Message upload() throws LfasrException {
        Message message = null;
        String task_id = "";
        if (!this.upParams.getLfasrType().isSupportedAudios(this.upParams.getFile())) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadWorker", this.upParams.getTaskId(), "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26402\", \"failed\":\"\u8f6c\u5199\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\u9519\u8bef!\", \"data\":\"\"}"));
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26402\", \"failed\":\"\u8f6c\u5199\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\u9519\u8bef!\", \"data\":\"\"}");
        }
        try {
            ChannelFileReader fr = new ChannelFileReader(this.upParams.getFile(), this.file_piece_size);
            long file_len = fr.getFileLength();
            if (file_len > 524288000L) {
                LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadWorker", this.upParams.getTaskId(), "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26403\", \"failed\":\"\u8f6c\u5199\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u8d85\u8fc7\u9650\u5b9a\u5927\u5c0f500M!\", \"data\":\"\"}"));
                throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26403\", \"failed\":\"\u8f6c\u5199\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u8d85\u8fc7\u9650\u5b9a\u5927\u5c0f500M!\", \"data\":\"\"}");
            }
            Double check_length = AudioLength.getLength(this.upParams.getFile().getAbsolutePath());
            this.upParams.setCheckLength(check_length);
            HttpWorker hw = new HttpWorker();
            String result = hw.prepare(this.upParams);
            try {
                message = JSON.parseObject(result, Message.class);
            }
            catch (Exception e) {
                LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadWorker", this.upParams.getTaskId(), "", "(-1) ms", "{\"ok\":\"-1\", \"err_no\":\"26502\", \"failed\":\"\u8f6c\u5199\u9884\u5904\u7406\u63a5\u53e3\u9519\u8bef!\", \"data\":\"\"}"), e);
                throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26502\", \"failed\":\"\u8f6c\u5199\u9884\u5904\u7406\u63a5\u53e3\u9519\u8bef!\", \"data\":\"\"}");
            }
            if (message.getOk() != 0 || StringUtils.isEmpty(message.getData())) {
                LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadWorker", this.upParams.getTaskId(), "", "(-1) ms", "prepare error:" + message.getFailed()));
                fr.close();
                return message;
            }
            LOGGER.info(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadWorker", this.upParams.getTaskId(), "", "(-1) ms", "prepare ok"));
            task_id = message.getData();
            LOGGER.info(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadWorker", task_id, "", "(-1) ms", "get task_id:%s" + task_id));
            this.upParams.setTaskId(task_id);
            this.metaPersistency(this.upParams);
            fr.close();
            UploadThread ut = new UploadThread(this.upParams, this.file_piece_size);
            Thread hbt = new Thread(ut);
            hbt.start();
            try {
                if (!this.upParams.getParams().get("not_wait").equalsIgnoreCase("true")) {
                    hbt.join();
                }
            }
            catch (Exception e) {
                hbt.join();
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadWorker", this.upParams.getTaskId(), "", "(-1) ms", "upload error"), e);
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26503\", \"failed\":\"\u8f6c\u5199\u4e0a\u4f20\u6587\u4ef6\u63a5\u53e3\u9519\u8bef!\", \"data\":\"\"}");
        }
        return message;
    }

    private void metaPersistency(UploadParams upParams) throws LfasrException {
        try {
            LocalPersistenceMeta lpm = new LocalPersistenceMeta();
            lpm.setAppId(upParams.getSignature().getAppID());
            lpm.setSecretKey(upParams.getSignature().getSecretKey());
            lpm.setSigna(upParams.getSignature().getSigna());
            lpm.setTs(upParams.getSignature().getTs());
            lpm.setLfasrType(upParams.getLfasrType().getValue());
            lpm.setFilePieceSize(this.file_piece_size);
            lpm.setTaskId(upParams.getTaskId());
            lpm.setFile(upParams.getFile().getAbsolutePath());
            lpm.setParams(upParams.getParams());
            String jsonStr = JSON.toJSONString(lpm);
            String fileName = String.valueOf(LfasrClientImp.SERV_STORE_PATH_VAL) + "/" + upParams.getTaskId() + ".dat";
            LocalPersistenceFile.writeNIO(fileName, jsonStr);
            LOGGER.info(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadWorker", upParams.getTaskId(), "", "(-1) ms", "write meta info success, store file:" + fileName));
        }
        catch (LfasrException e) {
            LOGGER.error(String.format("[COMPENT]-%s [PROCESS]-%s [ID]-%s [STATUS]-%s [MEASURE]-%s [DEF]-%s", "CLIENT", "UploadWorker", upParams.getTaskId(), "", "(-1) ms", "write meta info error"), e);
            throw new LfasrException("{\"ok\":\"-1\", \"err_no\":\"26301\", \"failed\":\"\u8f6c\u5199\u65ad\u70b9\u7eed\u4f20\u6301\u4e45\u5316\u6587\u4ef6\u8bfb\u5199\u9519\u8bef!\", \"data\":\"\"}");
        }
    }
}

