/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Level;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.logging.AbstractTagDisplayFormatter;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.logging.Hex;
import org.jaudiotagger.logging.PlainTextTagDisplayFormatter;
import org.jaudiotagger.logging.XMLTagDisplayFormatter;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3;
import org.jaudiotagger.tag.reference.ID3V2Version;
import sun.nio.ch.DirectBuffer;

public class MP3File
extends AudioFile {
    private static final int MINIMUM_FILESIZE = 150;
    protected static AbstractTagDisplayFormatter tagFormatter;
    private AbstractID3v2Tag id3v2tag = null;
    private ID3v24Tag id3v2Asv24tag = null;
    private AbstractLyrics3 lyrics3tag = null;
    private ID3v1Tag id3v1tag = null;
    public static final int LOAD_IDV1TAG = 2;
    public static final int LOAD_IDV2TAG = 4;
    public static final int LOAD_LYRICS3 = 8;
    public static final int LOAD_ALL = 14;

    public MP3File() {
    }

    public MP3File(String filename) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(new File(filename));
    }

    public MP3File(File file, int loadOptions) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(file, loadOptions, false);
    }

    private void readV1Tag(File file, RandomAccessFile newFile, int loadOptions) throws IOException {
        if ((loadOptions & 2) != 0) {
            logger.finer("Attempting to read id3v1tags");
            try {
                this.id3v1tag = new ID3v11Tag(newFile, file.getName());
            }
            catch (TagNotFoundException ex) {
                logger.config("No ids3v11 tag found");
            }
            try {
                if (this.id3v1tag == null) {
                    this.id3v1tag = new ID3v1Tag(newFile, file.getName());
                }
            }
            catch (TagNotFoundException ex) {
                logger.config("No id3v1 tag found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readV2Tag(File file, int loadOptions, int startByte) throws IOException, TagException {
        if (startByte >= 10) {
            ByteBuffer bb;
            logger.finer("Attempting to read id3v2tags");
            FileInputStream fis = null;
            AbstractInterruptibleChannel fc = null;
            try {
                fis = new FileInputStream(file);
                fc = fis.getChannel();
                bb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, startByte);
            }
            catch (IOException ioe) {
                bb = ByteBuffer.allocate(startByte);
                ((FileChannel)fc).read(bb, 0L);
            }
            finally {
                if (fc != null) {
                    fc.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            try {
                bb.rewind();
                if ((loadOptions & 4) == 0) return;
                logger.config("Attempting to read id3v2tags");
                try {
                    this.setID3v2Tag(new ID3v24Tag(bb, file.getName()));
                }
                catch (TagNotFoundException ex) {
                    logger.config("No id3v24 tag found");
                }
                try {
                    if (this.id3v2tag == null) {
                        this.setID3v2Tag(new ID3v23Tag(bb, file.getName()));
                    }
                }
                catch (TagNotFoundException ex) {
                    logger.config("No id3v23 tag found");
                }
                try {
                    if (this.id3v2tag != null) return;
                    this.setID3v2Tag(new ID3v22Tag(bb, file.getName()));
                    return;
                }
                catch (TagNotFoundException ex) {
                    logger.config("No id3v22 tag found");
                }
                return;
            }
            finally {
                bb.clear();
                if (bb != null && bb.isDirect()) {
                    ((DirectBuffer)((Object)bb)).cleaner().clean();
                }
            }
        }
        logger.config("Not enough room for valid id3v2 tag:" + startByte);
    }

    private void readLyrics3Tag(File file, RandomAccessFile newFile, int loadOptions) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFilePortionNull(int startByte, int endByte) throws IOException {
        logger.config("Checking file portion:" + Hex.asHex(startByte) + ":" + Hex.asHex(endByte));
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fis = new FileInputStream(this.file);
            fc = fis.getChannel();
            ((FileChannel)fc).position(startByte);
            ByteBuffer bb = ByteBuffer.allocateDirect(endByte - startByte);
            ((FileChannel)fc).read(bb);
            while (bb.hasRemaining()) {
                if (bb.get() == 0) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return true;
    }

    private MP3AudioHeader checkAudioStart(long startByte, MP3AudioHeader firstHeaderAfterTag) throws IOException, InvalidAudioFrameException {
        logger.warning(ErrorMessage.MP3_ID3TAG_LENGTH_INCORRECT.getMsg(this.file.getPath(), Hex.asHex(startByte), Hex.asHex(firstHeaderAfterTag.getMp3StartByte())));
        MP3AudioHeader headerOne = new MP3AudioHeader(this.file, 0L);
        logger.config("Checking from start:" + headerOne);
        if (firstHeaderAfterTag.getMp3StartByte() == headerOne.getMp3StartByte()) {
            logger.config(ErrorMessage.MP3_START_OF_AUDIO_CONFIRMED.getMsg(this.file.getPath(), Hex.asHex(headerOne.getMp3StartByte())));
            return firstHeaderAfterTag;
        }
        logger.config(ErrorMessage.MP3_RECALCULATED_POSSIBLE_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(headerOne.getMp3StartByte())));
        if (firstHeaderAfterTag.getNumberOfFrames() == headerOne.getNumberOfFrames()) {
            logger.warning(ErrorMessage.MP3_RECALCULATED_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(headerOne.getMp3StartByte())));
            return headerOne;
        }
        if (this.isFilePortionNull((int)startByte, (int)firstHeaderAfterTag.getMp3StartByte())) {
            return firstHeaderAfterTag;
        }
        MP3AudioHeader headerTwo = new MP3AudioHeader(this.file, headerOne.getMp3StartByte() + (long)headerOne.mp3FrameHeader.getFrameLength());
        if (headerTwo.getMp3StartByte() == firstHeaderAfterTag.getMp3StartByte()) {
            logger.warning(ErrorMessage.MP3_START_OF_AUDIO_CONFIRMED.getMsg(this.file.getPath(), Hex.asHex(firstHeaderAfterTag.getMp3StartByte())));
            return firstHeaderAfterTag;
        }
        if (headerTwo.getNumberOfFrames() == headerOne.getNumberOfFrames()) {
            logger.warning(ErrorMessage.MP3_RECALCULATED_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(headerOne.getMp3StartByte())));
            return headerOne;
        }
        logger.warning(ErrorMessage.MP3_RECALCULATED_START_OF_MP3_AUDIO.getMsg(this.file.getPath(), Hex.asHex(firstHeaderAfterTag.getMp3StartByte())));
        return firstHeaderAfterTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MP3File(File file, int loadOptions, boolean readOnly) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        RandomAccessFile newFile = null;
        try {
            this.file = file;
            newFile = this.checkFilePermissions(file, readOnly);
            long tagSizeReportedByHeader = AbstractID3v2Tag.getV2TagSizeIfExists(file);
            logger.config("TagHeaderSize:" + Hex.asHex(tagSizeReportedByHeader));
            this.audioHeader = new MP3AudioHeader(file, tagSizeReportedByHeader);
            if (tagSizeReportedByHeader != ((MP3AudioHeader)this.audioHeader).getMp3StartByte()) {
                logger.config("First header found after tag:" + this.audioHeader);
                this.audioHeader = this.checkAudioStart(tagSizeReportedByHeader, (MP3AudioHeader)this.audioHeader);
            }
            this.readV1Tag(file, newFile, loadOptions);
            this.readV2Tag(file, loadOptions, (int)((MP3AudioHeader)this.audioHeader).getMp3StartByte());
            if (this.getID3v2Tag() != null) {
                this.tag = this.getID3v2Tag();
            } else if (this.id3v1tag != null) {
                this.tag = this.id3v1tag;
            }
        }
        finally {
            if (newFile != null) {
                newFile.close();
            }
        }
    }

    public long getMP3StartByte(File file) throws InvalidAudioFrameException, IOException {
        try {
            long startByte = AbstractID3v2Tag.getV2TagSizeIfExists(file);
            MP3AudioHeader audioHeader = new MP3AudioHeader(file, startByte);
            if (startByte != audioHeader.getMp3StartByte()) {
                logger.config("First header found after tag:" + audioHeader);
                audioHeader = this.checkAudioStart(startByte, audioHeader);
            }
            return audioHeader.getMp3StartByte();
        }
        catch (InvalidAudioFrameException iafe) {
            throw iafe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public File extractID3v2TagDataIntoFile(File outputFile) throws TagNotFoundException, IOException {
        int startByte = (int)((MP3AudioHeader)this.audioHeader).getMp3StartByte();
        if (startByte >= 0) {
            FileInputStream fis = new FileInputStream(this.file);
            FileChannel fc = fis.getChannel();
            ByteBuffer bb = ByteBuffer.allocate(startByte);
            fc.read(bb);
            FileOutputStream out = new FileOutputStream(outputFile);
            out.write(bb.array());
            out.close();
            fc.close();
            fis.close();
            return outputFile;
        }
        throw new TagNotFoundException("There is no ID3v2Tag data in this file");
    }

    public MP3AudioHeader getMP3AudioHeader() {
        return (MP3AudioHeader)this.getAudioHeader();
    }

    public boolean hasID3v1Tag() {
        return this.id3v1tag != null;
    }

    public boolean hasID3v2Tag() {
        return this.id3v2tag != null;
    }

    public MP3File(File file) throws IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        this(file, 14);
    }

    public void setID3v1Tag(ID3v1Tag id3v1tag) {
        logger.config("setting tagv1:v1 tag");
        this.id3v1tag = id3v1tag;
    }

    public void setID3v1Tag(Tag id3v1tag) {
        logger.config("setting tagv1:v1 tag");
        this.id3v1tag = (ID3v1Tag)id3v1tag;
    }

    public void setID3v1Tag(AbstractTag mp3tag) {
        logger.config("setting tagv1:abstract");
        this.id3v1tag = new ID3v11Tag(mp3tag);
    }

    public ID3v1Tag getID3v1Tag() {
        return this.id3v1tag;
    }

    public void setID3v2Tag(AbstractTag mp3tag) {
        this.id3v2tag = new ID3v24Tag(mp3tag);
    }

    public void setID3v2Tag(AbstractID3v2Tag id3v2tag) {
        this.id3v2tag = id3v2tag;
        this.id3v2Asv24tag = id3v2tag instanceof ID3v24Tag ? (ID3v24Tag)this.id3v2tag : new ID3v24Tag((AbstractTag)id3v2tag);
    }

    public void setID3v2TagOnly(AbstractID3v2Tag id3v2tag) {
        this.id3v2tag = id3v2tag;
        this.id3v2Asv24tag = null;
    }

    public AbstractID3v2Tag getID3v2Tag() {
        return this.id3v2tag;
    }

    public ID3v24Tag getID3v2TagAsv24() {
        return this.id3v2Asv24tag;
    }

    public void delete(AbstractTag mp3tag) throws FileNotFoundException, IOException {
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        mp3tag.delete(raf);
        raf.close();
        if (mp3tag instanceof ID3v1Tag) {
            this.id3v1tag = null;
        }
        if (mp3tag instanceof AbstractID3v2Tag) {
            this.id3v2tag = null;
        }
    }

    public void save() throws IOException, TagException {
        this.save(this.file);
    }

    public void commit() throws CannotWriteException {
        try {
            this.save();
        }
        catch (IOException ioe) {
            throw new CannotWriteException(ioe);
        }
        catch (TagException te) {
            throw new CannotWriteException(te);
        }
    }

    public void precheck(File file) throws IOException {
        if (!file.exists()) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_NOT_FOUND.getMsg(file.getName()));
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_NOT_FOUND.getMsg(file.getName()));
        }
        if (!file.canWrite()) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(file.getName()));
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED.getMsg(file.getName()));
        }
        if (file.length() <= 150L) {
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file.getName()));
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_IS_TOO_SMALL.getMsg(file.getName()));
        }
    }

    public void save(File fileToSave) throws IOException {
        File file = fileToSave.getAbsoluteFile();
        logger.config("Saving  : " + file.getPath());
        this.precheck(file);
        RandomAccessFile rfile = null;
        try {
            if (TagOptionSingleton.getInstance().isId3v2Save()) {
                if (this.id3v2tag == null) {
                    rfile = new RandomAccessFile(file, "rw");
                    new ID3v24Tag().delete(rfile);
                    new ID3v23Tag().delete(rfile);
                    new ID3v22Tag().delete(rfile);
                    logger.config("Deleting ID3v2 tag:" + file.getName());
                    rfile.close();
                } else {
                    logger.config("Writing ID3v2 tag:" + file.getName());
                    MP3AudioHeader mp3AudioHeader = (MP3AudioHeader)this.getAudioHeader();
                    long mp3StartByte = mp3AudioHeader.getMp3StartByte();
                    long newMp3StartByte = this.id3v2tag.write(file, mp3StartByte);
                    if (mp3StartByte != newMp3StartByte) {
                        logger.config("New mp3 start byte: " + newMp3StartByte);
                        mp3AudioHeader.setMp3StartByte(newMp3StartByte);
                    }
                }
            }
            rfile = new RandomAccessFile(file, "rw");
            if (TagOptionSingleton.getInstance().isLyrics3Save() && this.lyrics3tag != null) {
                this.lyrics3tag.write(rfile);
            }
            if (TagOptionSingleton.getInstance().isId3v1Save()) {
                logger.config("Processing ID3v1");
                if (this.id3v1tag == null) {
                    logger.config("Deleting ID3v1");
                    new ID3v1Tag().delete(rfile);
                } else {
                    logger.config("Saving ID3v1");
                    this.id3v1tag.write(rfile);
                }
            }
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE_FILE_NOT_FOUND.getMsg(file.getName()), ex);
            throw ex;
        }
        catch (IOException iex) {
            logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE.getMsg(file.getName(), iex.getMessage()), iex);
            throw iex;
        }
        catch (RuntimeException re) {
            logger.log(Level.SEVERE, ErrorMessage.GENERAL_WRITE_FAILED_BECAUSE.getMsg(file.getName(), re.getMessage()), re);
            throw re;
        }
        finally {
            if (rfile != null) {
                rfile.close();
            }
        }
    }

    public String displayStructureAsXML() {
        MP3File.createXMLStructureFormatter();
        tagFormatter.openHeadingElement("file", this.getFile().getAbsolutePath());
        if (this.getID3v1Tag() != null) {
            this.getID3v1Tag().createStructure();
        }
        if (this.getID3v2Tag() != null) {
            this.getID3v2Tag().createStructure();
        }
        tagFormatter.closeHeadingElement("file");
        return tagFormatter.toString();
    }

    public String displayStructureAsPlainText() {
        MP3File.createPlainTextStructureFormatter();
        tagFormatter.openHeadingElement("file", this.getFile().getAbsolutePath());
        if (this.getID3v1Tag() != null) {
            this.getID3v1Tag().createStructure();
        }
        if (this.getID3v2Tag() != null) {
            this.getID3v2Tag().createStructure();
        }
        tagFormatter.closeHeadingElement("file");
        return tagFormatter.toString();
    }

    private static void createXMLStructureFormatter() {
        tagFormatter = new XMLTagDisplayFormatter();
    }

    private static void createPlainTextStructureFormatter() {
        tagFormatter = new PlainTextTagDisplayFormatter();
    }

    public static AbstractTagDisplayFormatter getStructureFormatter() {
        return tagFormatter;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
        if (tag instanceof ID3v1Tag) {
            this.setID3v1Tag((ID3v1Tag)tag);
        } else {
            this.setID3v2Tag((AbstractID3v2Tag)tag);
        }
    }

    public Tag createDefaultTag() {
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V24) {
            return new ID3v24Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V23) {
            return new ID3v23Tag();
        }
        if (TagOptionSingleton.getInstance().getID3V2Version() == ID3V2Version.ID3_V22) {
            return new ID3v22Tag();
        }
        return new ID3v24Tag();
    }

    public Tag convertTag(Tag tag, ID3V2Version id3V2Version) {
        if (tag instanceof ID3v24Tag) {
            switch (id3V2Version) {
                case ID3_V22: {
                    return new ID3v22Tag((AbstractTag)((ID3v24Tag)tag));
                }
                case ID3_V23: {
                    return new ID3v23Tag((AbstractTag)((ID3v24Tag)tag));
                }
                case ID3_V24: {
                    return tag;
                }
            }
        } else if (tag instanceof ID3v23Tag) {
            switch (id3V2Version) {
                case ID3_V22: {
                    return new ID3v22Tag((AbstractTag)((ID3v23Tag)tag));
                }
                case ID3_V23: {
                    return tag;
                }
                case ID3_V24: {
                    return new ID3v24Tag((AbstractTag)((ID3v23Tag)tag));
                }
            }
        } else if (tag instanceof ID3v22Tag) {
            switch (id3V2Version) {
                case ID3_V22: {
                    return tag;
                }
                case ID3_V23: {
                    return new ID3v23Tag((AbstractTag)((ID3v22Tag)tag));
                }
                case ID3_V24: {
                    return new ID3v24Tag((AbstractTag)((ID3v22Tag)tag));
                }
            }
        }
        return tag;
    }

    public Tag getTagOrCreateDefault() {
        AbstractID3v2Tag tag = this.getID3v2Tag();
        if (tag == null) {
            return this.createDefaultTag();
        }
        return tag;
    }

    public Tag getTagAndConvertOrCreateAndSetDefault() {
        Tag tag = this.getTagOrCreateDefault();
        tag = this.convertTag(tag, TagOptionSingleton.getInstance().getID3V2Version());
        this.setTag(tag);
        return tag;
    }
}

