/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.SynchronisedTempoCode;
import org.jaudiotagger.tag.datatype.SynchronisedTempoCodeList;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v23FrameBody;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.id3.valuepair.EventTimingTimestampTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameBodySYTC
extends AbstractID3v2FrameBody
implements ID3v24FrameBody,
ID3v23FrameBody {
    public static final int MPEG_FRAMES = 1;
    public static final int MILLISECONDS = 2;

    public FrameBodySYTC() {
        this.setObjectValue("TimeStampFormat", 2);
    }

    public FrameBodySYTC(int timestampFormat, byte[] tempo) {
        this.setObjectValue("TimeStampFormat", timestampFormat);
        this.setObjectValue("SynchronisedTempoList", tempo);
    }

    public FrameBodySYTC(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public FrameBodySYTC(FrameBodySYTC body) {
        super(body);
    }

    public int getTimestampFormat() {
        return ((Number)this.getObjectValue("TimeStampFormat")).intValue();
    }

    public void setTimestampFormat(int timestampFormat) {
        if (EventTimingTimestampTypes.getInstanceOf().getValueForId(timestampFormat) == null) {
            throw new IllegalArgumentException("Timestamp format must be 1 or 2 (ID3v2.4, 4.7): " + timestampFormat);
        }
        this.setObjectValue("TimeStampFormat", timestampFormat);
    }

    public Map<Long, Integer> getTempi() {
        LinkedHashMap<Long, Integer> map = new LinkedHashMap<Long, Integer>();
        List codes = (List)this.getObjectValue("SynchronisedTempoList");
        for (SynchronisedTempoCode code : codes) {
            map.put(code.getTimestamp(), code.getTempo());
        }
        return Collections.unmodifiableMap(map);
    }

    public List<Long> getTimestamps() {
        ArrayList<Long> list = new ArrayList<Long>();
        List codes = (List)this.getObjectValue("SynchronisedTempoList");
        for (SynchronisedTempoCode code : codes) {
            list.add(code.getTimestamp());
        }
        return Collections.unmodifiableList(list);
    }

    public void addTempo(long timestamp, int tempo) {
        this.removeTempo(timestamp);
        List codes = (List)this.getObjectValue("SynchronisedTempoList");
        int insertIndex = 0;
        if (!codes.isEmpty() && ((SynchronisedTempoCode)codes.get(0)).getTimestamp() <= timestamp) {
            SynchronisedTempoCode code;
            long translatedTimestamp;
            Iterator iterator = codes.iterator();
            while (iterator.hasNext() && timestamp >= (translatedTimestamp = (code = (SynchronisedTempoCode)iterator.next()).getTimestamp())) {
                ++insertIndex;
            }
        }
        codes.add(insertIndex, new SynchronisedTempoCode("SynchronisedTempo", this, tempo, timestamp));
    }

    public boolean removeTempo(long timestamp) {
        List codes = (List)this.getObjectValue("SynchronisedTempoList");
        boolean removed = false;
        ListIterator iterator = codes.listIterator();
        while (iterator.hasNext()) {
            SynchronisedTempoCode code = (SynchronisedTempoCode)iterator.next();
            if (timestamp == code.getTimestamp()) {
                iterator.remove();
                removed = true;
            }
            if (timestamp <= code.getTimestamp()) continue;
            break;
        }
        return removed;
    }

    public void clearTempi() {
        ((List)this.getObjectValue("SynchronisedTempoList")).clear();
    }

    @Override
    public String getIdentifier() {
        return "SYTC";
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        super.read(byteBuffer);
        List codes = (List)this.getObjectValue("SynchronisedTempoList");
        long lastTimestamp = 0L;
        for (SynchronisedTempoCode code : codes) {
            if (code.getTimestamp() < lastTimestamp) {
                logger.warning("Synchronised tempo codes are not in chronological order. " + lastTimestamp + " is followed by " + code.getTimestamp() + ".");
            }
            lastTimestamp = code.getTimestamp();
        }
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TimeStampFormat", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new SynchronisedTempoCodeList(this));
    }
}

