/*
 * Decompiled with CFR 0.152.
 */
package com.abchina.openbank;

import com.abchina.openbank.OpenBankHttpClient;
import com.abchina.openbank.dto.OpenBankHttpResponse;
import com.abchina.openbank.util.Utilities;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenBankHttpRequest {
    private static Logger logger = LoggerFactory.getLogger(OpenBankHttpRequest.class);
    private String appId;
    private String bizData;
    private String signType;
    private String sign;
    private String encryptType;
    private String encryptData;
    private String timestamp;
    private String nonce;
    private String requestUrl;
    private Map<String, Object> header = new HashMap<String, Object>();
    private String requestString;
    private int timeout = 0;
    private String returnRequestStringH5;

    public String getReturnRequestStringH5() {
        return this.returnRequestStringH5;
    }

    public void setReturnRequestStringH5(String returnRequestStringH5) {
        this.returnRequestStringH5 = returnRequestStringH5;
    }

    public void setBizData(String data) {
        this.bizData = data == null ? "" : data;
    }

    public void setBizData(Object data) throws Exception {
        this.bizData = data == null ? "" : new ObjectMapper().writeValueAsString(data);
    }

    public void generateRequestStringH5() {
        StringBuilder temp = new StringBuilder("?encrypt_type=" + URLEncoder.encode(this.encryptType));
        temp.append("&appid=" + URLEncoder.encode(this.appId));
        temp.append("&sign=" + URLEncoder.encode(this.sign));
        temp.append("&encrypt_data=" + URLEncoder.encode(this.encryptData));
        temp.append("&biz_data=" + URLEncoder.encode(this.bizData));
        temp.append("&sign_type=" + URLEncoder.encode(this.signType));
        temp.append("&nonce=" + URLEncoder.encode(this.nonce));
        temp.append("&timestamp=" + URLEncoder.encode(this.timestamp));
        this.returnRequestStringH5 = this.requestUrl + temp.toString();
    }

    public void generateRequestString() throws Exception {
        this.appId = OpenBankHttpClient.getInstance().getAppId();
        this.encryptType = "AES";
        if (this.encryptType != null && !this.encryptType.isEmpty()) {
            this.encryptData = OpenBankHttpClient.getInstance().getAesCrypt().enAESCrypt(this.bizData);
            this.bizData = "";
        } else {
            this.encryptData = "";
        }
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.timestamp = format.format(date);
        this.nonce = UUID.randomUUID().toString().replace("-", "");
        Map<String, Object> map = this.dataBind();
        String plainTxt = this.getPlainText(map);
        logger.info("\u7b7e\u540d\u660e\u6587:" + plainTxt);
        this.sign = OpenBankHttpClient.getInstance().getSignService().signData(plainTxt);
        map.put("sign", this.sign);
        logger.info("\u7b7e\u540d\u7ed3\u679c:" + this.sign);
        ObjectMapper mapper = new ObjectMapper();
        this.requestString = mapper.writeValueAsString(map);
        logger.info("\u8bf7\u6c42\u62a5\u6587:" + this.requestString);
        this.generateRequestStringH5();
    }

    public String sendAndRecv() throws Exception {
        String rtnString = "";
        String responseTxt = "";
        Utilities.isNotNull(this.requestUrl, "RequestUrl");
        Utilities.isNotNull(this.requestString, "requestString");
        int timeOut = this.timeout > 0 ? this.timeout : 60000;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeOut).setConnectTimeout(timeOut).setSocketTimeout(timeOut).build();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(this.requestUrl);
        if (this.header != null && this.header.size() > 0) {
            for (Map.Entry<String, Object> entry : this.header.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        httpPost.setEntity((HttpEntity)new StringEntity(this.requestString, "UTF-8"));
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        if (httpResponse != null) {
            int resCode = httpResponse.getStatusLine().getStatusCode();
            if (resCode == 403) {
                throw new Exception("\u60a8\u5df2\u88ab\u9650\u6d41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            if (resCode != 200) {
                throw new Exception("\u6ca1\u6709\u54cd\u5e94,\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\u6216\u7f51\u7edc\u8fde\u901a\u6027!");
            }
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) {
                throw new Exception("\u6ca1\u6709\u54cd\u5e94,\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\u6216\u7f51\u7edc\u8fde\u901a\u6027!");
            }
            responseTxt = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (responseTxt == null || responseTxt.isEmpty()) {
                throw new Exception("\u6ca1\u6709\u54cd\u5e94,\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\u6216\u7f51\u7edc\u8fde\u901a\u6027!");
            }
        }
        logger.info("\u5b8c\u6574\u54cd\u5e94\u62a5\u6587:" + responseTxt);
        ObjectMapper mapper = new ObjectMapper();
        JavaType javaType = mapper.getTypeFactory().constructType(OpenBankHttpResponse.class);
        OpenBankHttpResponse openBankHttpResponse = (OpenBankHttpResponse)mapper.readValue(responseTxt.toString(), javaType);
        if (openBankHttpResponse == null) {
            throw new Exception("\u54cd\u5e94\u62a5\u6587\u89e3\u6790\u5931\u8d25!" + responseTxt.toString());
        }
        if (openBankHttpResponse.getCode() != null && !openBankHttpResponse.getCode().isEmpty()) {
            if (openBankHttpResponse.getMsg() != null && !openBankHttpResponse.getMsg().isEmpty()) {
                if (!openBankHttpResponse.getCode().equals("0000")) {
                    throw new Exception("\u8c03\u7528\u7f51\u5173\u5931\u8d25\uff0c\u8fd4\u56de\u62a5\u6587:" + responseTxt.toString());
                }
                if ((openBankHttpResponse.getBiz_content() == null || openBankHttpResponse.getBiz_content().isEmpty()) && (openBankHttpResponse.getBiz_encrypt() == null || openBankHttpResponse.getBiz_encrypt().isEmpty())) {
                    throw new Exception("\u8fd4\u56de\u62a5\u6587\u4e1a\u52a1\u5b57\u6bb5\u548c\u52a0\u5bc6\u4e1a\u52a1\u5b57\u6bb5\u90fd\u4e3a\u7a7a!" + responseTxt.toString());
                }
                if (openBankHttpResponse.getResponseid() != null && !openBankHttpResponse.getResponseid().isEmpty()) {
                    Boolean verifyResponseRes = true;
                    String responsePlainTxt = "";
                    if (openBankHttpResponse.getSign() != null && !openBankHttpResponse.getSign().isEmpty()) {
                        responsePlainTxt = Utilities.getResponseText(openBankHttpResponse);
                        if ("HASHANDSHA256".equals(this.signType)) {
                            String responsePlainTxt256 = Utilities.computeSHA256(responsePlainTxt);
                            verifyResponseRes = OpenBankHttpClient.getInstance().getSignService().verifyResponseData(responsePlainTxt256, openBankHttpResponse.getSign());
                            if (!verifyResponseRes.booleanValue()) {
                                verifyResponseRes = OpenBankHttpClient.getInstance().getSignService().verifyResponseData(responsePlainTxt, openBankHttpResponse.getSign());
                            }
                        } else if ("SHA256".equals(this.signType)) {
                            verifyResponseRes = OpenBankHttpClient.getInstance().getSignService().verifyResponseData(responsePlainTxt, openBankHttpResponse.getSign());
                        }
                    }
                    if (!verifyResponseRes.booleanValue()) {
                        throw new Exception("\u54cd\u5e94\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25,\u9a8c\u7b7e\u660e\u6587" + responsePlainTxt + "\r\n\u7f51\u5173\u8fd4\u56de\u62a5\u6587:" + responseTxt.toString());
                    }
                    rtnString = openBankHttpResponse.getBiz_encrypt() != null && !openBankHttpResponse.getBiz_encrypt().isEmpty() ? OpenBankHttpClient.getInstance().getAesCrypt().deAESCrypt(openBankHttpResponse.getBiz_encrypt()) : openBankHttpResponse.getBiz_content();
                    httpResponse.close();
                    httpClient.close();
                    logger.info("\u4e1a\u52a1\u54cd\u5e94\u62a5\u6587:" + rtnString + "\tresponseid:" + openBankHttpResponse.getResponseid());
                    return rtnString;
                }
                throw new Exception("\u8fd4\u56de\u62a5\u6587responseid\u4e3a\u7a7a!" + responseTxt.toString());
            }
            throw new Exception("\u8fd4\u56de\u62a5\u6587msg\u4e3a\u7a7a!" + responseTxt.toString());
        }
        throw new Exception("\u8fd4\u56de\u62a5\u6587code\u4e3a\u7a7a!" + responseTxt.toString());
    }

    private String getPlainText(Map<String, Object> map) throws NoSuchAlgorithmException {
        String plainTxt = "";
        plainTxt = this.signType.equals("SHA256") ? Utilities.getSignPlainText(map) : Utilities.computeSHA256(Utilities.getSignPlainText(map));
        return plainTxt;
    }

    private Map<String, Object> dataBind() {
        try {
            Utilities.isNotNull(this.appId, "APPID");
            Utilities.isNotNull(this.signType, "Sign_Type");
        }
        catch (Exception var2) {
            var2.printStackTrace();
            return null;
        }
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("appid", this.appId);
        req.put("biz_data", this.bizData);
        req.put("sign_type", this.signType);
        req.put("encrypt_type", this.encryptType);
        req.put("encrypt_data", this.encryptData);
        req.put("timestamp", this.timestamp);
        req.put("nonce", this.nonce);
        return req;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getRequestString() {
        return this.requestString;
    }

    public Map<String, Object> getHeader() {
        return this.header;
    }

    public void setHeader(Map<String, Object> header) {
        this.header = header;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }
}

