/*
 * Decompiled with CFR 0.152.
 */
package com.abchina.openbank.sign;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Base64;

public class RawSignService {
    private static String CHARSET_ENCODING = "UTF-8";
    private static String ALGORITHM = "SHA256withRsa";
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private PublicKey abcPublicKey;

    public RawSignService(String myPFXPath, String myPFXPwd, String abcPubCertPath) throws Exception {
        try {
            String keyAlis = "";
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            FileInputStream fileInputStream = new FileInputStream(myPFXPath);
            char[] nPassword = null;
            if (myPFXPwd != null && !myPFXPwd.isEmpty()) {
                nPassword = myPFXPwd.toCharArray();
            }
            keyStore.load(fileInputStream, nPassword);
            fileInputStream.close();
            Enumeration<String> enumeration = keyStore.aliases();
            if (enumeration.hasMoreElements()) {
                keyAlis = enumeration.nextElement();
            }
            this.privateKey = (PrivateKey)keyStore.getKey(keyAlis, nPassword);
            Certificate certificate = null;
            String keyAlias = "";
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                keyAlias = enumeration.nextElement();
                if (!keyStore.isKeyEntry(keyAlias)) continue;
                certificate = (X509Certificate)keyStore.getCertificate(keyAlias);
            }
            this.publicKey = certificate.getPublicKey();
            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
            FileInputStream bais = new FileInputStream(abcPubCertPath);
            X509Certificate cert = (X509Certificate)certificatefactory.generateCertificate(bais);
            this.abcPublicKey = cert.getPublicKey();
        }
        catch (Exception var14) {
            var14.printStackTrace();
            throw new Exception("\u8bc1\u4e66\u8bfb\u53d6\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:" + var14.getMessage());
        }
    }

    public String signData(String plainTxt) throws Exception {
        if (plainTxt != null && !plainTxt.isEmpty()) {
            if (this.privateKey == null) {
                throw new Exception("\u5bc6\u94a5\u8bc1\u4e66\u8bfb\u53d6\u5931\u8d25.");
            }
            try {
                byte[] plainTxtBytes = plainTxt.getBytes(CHARSET_ENCODING);
                Signature signature = Signature.getInstance(ALGORITHM);
                signature.initSign(this.privateKey);
                signature.update(plainTxtBytes);
                byte[] result = signature.sign();
                return Base64.encodeBase64String((byte[])result);
            }
            catch (Exception var5) {
                var5.printStackTrace();
                throw new Exception("\u7b7e\u540d\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:" + var5.getMessage());
            }
        }
        throw new Exception("\u7b7e\u540d\u660e\u6587\u4e0d\u80fd\u4e3a\u7a7a.");
    }

    public boolean verifyRequestData(String plainTxt, String signedTxt) throws Exception {
        if (plainTxt != null && !plainTxt.isEmpty()) {
            if (signedTxt != null && !signedTxt.isEmpty()) {
                if (this.publicKey == null) {
                    throw new Exception("\u516c\u94a5\u8bc1\u4e66\u8bfb\u53d6\u5931\u8d25.");
                }
                try {
                    Signature sign = Signature.getInstance(ALGORITHM);
                    sign.initVerify(this.publicKey);
                    sign.update(plainTxt.getBytes(CHARSET_ENCODING));
                    return sign.verify(Base64.decodeBase64((String)signedTxt));
                }
                catch (Exception var4) {
                    var4.printStackTrace();
                    throw new Exception("\u8bf7\u6c42\u62a5\u6587\u9a8c\u7b7e\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:" + var4.getMessage());
                }
            }
            throw new Exception("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        throw new Exception("\u7b7e\u540d\u660e\u6587\u4e0d\u80fd\u4e3a\u7a7a.");
    }

    public boolean verifyResponseData(String plainTxt, String signedTxt) throws Exception {
        if (plainTxt != null && !plainTxt.isEmpty()) {
            if (signedTxt != null && !signedTxt.isEmpty()) {
                if (this.abcPublicKey == null) {
                    throw new Exception("\u519c\u884c\u516c\u94a5\u8bc1\u4e66\u8bfb\u53d6\u5931\u8d25.");
                }
                try {
                    Signature sign = Signature.getInstance(ALGORITHM);
                    sign.initVerify(this.abcPublicKey);
                    sign.update(plainTxt.getBytes(CHARSET_ENCODING));
                    return sign.verify(Base64.decodeBase64((String)signedTxt));
                }
                catch (Exception var4) {
                    var4.printStackTrace();
                    throw new Exception("\u54cd\u5e94\u62a5\u6587\u9a8c\u7b7e\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:" + var4.getMessage());
                }
            }
            throw new Exception("\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        throw new Exception("\u7b7e\u540d\u660e\u6587\u4e0d\u80fd\u4e3a\u7a7a.");
    }
}

