/*
 * Decompiled with CFR 0.152.
 */
package com.abchina.openbank.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Base64;

public class Utilities {
    public static String getSignPlainText(Map<String, Object> msg) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder signPlainText = new StringBuilder();
        for (Map.Entry<String, Object> pi : msg.entrySet()) {
            if (pi == null || pi.getValue() == null || pi.getValue().equals("") || pi.getKey().trim().toLowerCase().equals("sign") || pi.getKey().trim().toLowerCase().equals("code") || pi.getKey().trim().toLowerCase().equals("msg")) continue;
            map.put(pi.getKey(), pi.getValue().toString());
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String key : map.keySet()) {
            treeSet.add(key);
        }
        for (String key : treeSet) {
            signPlainText.append((String)map.get(key) + "@");
        }
        if (signPlainText.length() - 1 >= 0) {
            signPlainText.deleteCharAt(signPlainText.length() - 1);
        }
        return signPlainText.toString();
    }

    public static <T> String getResponseText(T msg) {
        Class<?> c = msg.getClass();
        Field[] fields = c.getDeclaredFields();
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder signPlainText = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            int mdf = fields[i].getModifiers();
            if (!Modifier.isPrivate(mdf)) continue;
            Object value = null;
            try {
                fields[i].setAccessible(true);
                value = fields[i].get(msg);
            }
            catch (IllegalAccessException | IllegalArgumentException var9) {
                var9.printStackTrace();
            }
            if (value == null || value.equals("") || fields[i].getName().trim().toLowerCase().equals("sign") || fields[i].getName().trim().toLowerCase().equals("code") || fields[i].getName().trim().toLowerCase().equals("msg") || fields[i].getName().trim().toLowerCase().equals("sign_type") || fields[i].getName().trim().toLowerCase().equals("encrypt_type") || fields[i].getName().trim().toLowerCase().equals("gateWayResponse")) continue;
            map.put(fields[i].getName(), value.toString());
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String key : map.keySet()) {
            if (!"biz_encrypt".equals(key) && !"responseid".equals(key)) continue;
            treeSet.add(key);
        }
        for (String key : treeSet) {
            signPlainText.append((String)map.get(key) + "@");
        }
        if (signPlainText.length() - 1 >= 0) {
            signPlainText.deleteCharAt(signPlainText.length() - 1);
        }
        return signPlainText.toString();
    }

    public static String computeSHA256(String signPlainText) throws NoSuchAlgorithmException {
        byte[] hashBytes = Utilities.sha256(signPlainText);
        return Base64.encodeBase64String((byte[])hashBytes);
    }

    private static byte[] sha256(String strText) throws NoSuchAlgorithmException {
        return Utilities.sha(strText, "SHA-256");
    }

    private static byte[] sha(String strText, String strType) throws NoSuchAlgorithmException {
        byte[] byteBuffer = null;
        if (strText != null && strText.length() > 0) {
            MessageDigest messageDigest = MessageDigest.getInstance(strType);
            messageDigest.update(strText.getBytes(StandardCharsets.UTF_8));
            byteBuffer = messageDigest.digest();
        }
        return byteBuffer;
    }

    public static void isNotNull(String str, String strName) throws Exception {
        if (str == null || str.isEmpty()) {
            throw new Exception(strName + "\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
    }
}

