/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.MaQrcodeCommonCreateResponse;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaQrcodeCommonCreateRequest
implements TaobaoRequest<MaQrcodeCommonCreateResponse> {
    private Map<String, String> headerMap = new TaobaoHashMap();
    private TaobaoHashMap udfParams;
    private Long timestamp;
    private String channelName;
    private String content;
    private String logo;
    private String name;
    private Boolean needEps;
    private Long size;
    private String style;
    private String type;

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNeedEps(Boolean needEps) {
        this.needEps = needEps;
    }

    public Boolean getNeedEps() {
        return this.needEps;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getSize() {
        return this.size;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.ma.qrcode.common.create";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("channel_name", this.channelName);
        txtParams.put("content", this.content);
        txtParams.put("logo", this.logo);
        txtParams.put("name", this.name);
        txtParams.put("need_eps", (Object)this.needEps);
        txtParams.put("size", (Object)this.size);
        txtParams.put("style", this.style);
        txtParams.put("type", this.type);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public void putOtherTextParam(String key, String value) {
        if (this.udfParams == null) {
            this.udfParams = new TaobaoHashMap();
        }
        this.udfParams.put(key, value);
    }

    @Override
    public Class<MaQrcodeCommonCreateResponse> getResponseClass() {
        return MaQrcodeCommonCreateResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkMaxLength(this.channelName, 160, "channelName");
        RequestCheckUtils.checkNotEmpty(this.content, "content");
        RequestCheckUtils.checkMaxLength(this.content, 256, "content");
        RequestCheckUtils.checkMaxLength(this.logo, 256, "logo");
        RequestCheckUtils.checkNotEmpty(this.name, "name");
        RequestCheckUtils.checkMaxLength(this.name, 32, "name");
        RequestCheckUtils.checkNotEmpty(this.size, "size");
        RequestCheckUtils.checkMaxValue(this.size, 300L, "size");
        RequestCheckUtils.checkMinValue(this.size, 60L, "size");
        RequestCheckUtils.checkNotEmpty(this.style, "style");
        RequestCheckUtils.checkMaxLength(this.style, 50, "style");
        RequestCheckUtils.checkNotEmpty(this.type, "type");
        RequestCheckUtils.checkMaxLength(this.type, 10, "type");
    }

    @Override
    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }
}

