/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.channel.embedded;

import com.taobao.top.link.ResetableTimer;
import com.taobao.top.link.Text;
import com.taobao.top.link.channel.ChannelException;
import com.taobao.top.link.channel.ChannelHandler;
import com.taobao.top.link.channel.ChannelSender;
import com.taobao.top.link.channel.ClientChannel;
import com.taobao.top.link.embedded.websocket.WebSocket;
import com.taobao.top.link.embedded.websocket.exception.WebSocketException;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.CloseFrame;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.FrameRfc6455;
import com.taobao.top.link.embedded.websocket.frame.rfc6455.PingFrame;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;

public class EmbeddedWebSocketClientChannel
implements ClientChannel {
    private URI uri;
    protected WebSocket socket;
    protected Exception error;
    private ChannelHandler channelHandler;
    private ResetableTimer heartbeatTimer;

    public SocketAddress getLocalAddress() {
        return null;
    }

    public SocketAddress getRemoteAddress() {
        return null;
    }

    public ChannelHandler getChannelHandler() {
        this.delayPing();
        return this.channelHandler;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setChannelHandler(ChannelHandler handler) {
        this.channelHandler = handler;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public void close(String reason) {
        this.stopHeartbeat();
        try {
            CloseFrame frame = new CloseFrame(1000, reason != null ? reason : Text.WS_UNKNOWN_ERROR);
            frame.mask();
            this.socket.send(frame);
        }
        catch (WebSocketException webSocketException) {
            // empty catch block
        }
    }

    public void setHeartbeatTimer(ResetableTimer timer) {
        this.stopHeartbeat();
        this.heartbeatTimer = timer;
        this.heartbeatTimer.setTask(new Runnable(){

            public void run() {
                if (!EmbeddedWebSocketClientChannel.this.isConnected()) {
                    return;
                }
                PingFrame pingFrame = new PingFrame();
                pingFrame.mask();
                try {
                    EmbeddedWebSocketClientChannel.this.socket.send(pingFrame);
                }
                catch (WebSocketException webSocketException) {
                    // empty catch block
                }
            }
        });
        this.heartbeatTimer.start();
    }

    public void send(ByteBuffer dataBuffer, ChannelSender.SendHandler sendHandler) throws ChannelException {
        this.checkChannel();
        try {
            FrameRfc6455 frame = (FrameRfc6455)this.socket.createFrame(dataBuffer);
            frame.mask();
            this.socket.send(frame);
        }
        catch (WebSocketException e) {
            throw new ChannelException(Text.WS_SEND_ERROR, e);
        }
        finally {
            if (sendHandler != null) {
                sendHandler.onSendComplete(true);
            }
        }
    }

    public void send(byte[] data, int offset, int length) throws ChannelException {
        this.send(ByteBuffer.wrap(data, offset, length), null);
    }

    public boolean sendSync(ByteBuffer dataBuffer, ChannelSender.SendHandler sendHandler, int timeoutMilliseconds) throws ChannelException {
        throw new ChannelException(Text.DO_NOT_SUPPORT);
    }

    private void checkChannel() throws ChannelException {
        if (!this.socket.isConnected()) {
            this.stopHeartbeat();
            throw new ChannelException(Text.CHANNEL_CLOSED);
        }
        this.delayPing();
    }

    private void delayPing() {
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.delay();
        }
    }

    private void stopHeartbeat() {
        if (this.heartbeatTimer != null) {
            try {
                this.heartbeatTimer.stop();
                this.heartbeatTimer = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

