/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.frame.draft76;

import com.taobao.top.link.embedded.websocket.frame.FrameHeader;
import com.taobao.top.link.embedded.websocket.frame.draft76.FrameDraft76;
import com.taobao.top.link.embedded.websocket.frame.draft76.FrameHeaderDraft76;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class TextFrame
extends FrameDraft76 {
    private String convertedString;

    public TextFrame(String str) {
        byte[] body = TextFrame.convertStringToByteArray(str);
        FrameHeaderDraft76 header = new FrameHeaderDraft76(0, body.length + 1);
        this.setHeader(header);
        this.setContents(body);
    }

    public TextFrame(FrameHeader header, byte[] body) {
        super(header, TextFrame.stripTerminateFlag(body));
    }

    private static byte[] stripTerminateFlag(byte[] body) {
        if (body[body.length - 1] == -1) {
            byte[] tmp = new byte[body.length - 1];
            System.arraycopy(body, 0, tmp, 0, body.length - 2);
            body = tmp;
        }
        return body;
    }

    private static byte[] convertStringToByteArray(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(1 + this.contents.length + 1);
        buf.put(this.header.toByteBuffer());
        buf.put(this.contents);
        buf.put((byte)-1);
        buf.flip();
        return buf;
    }

    public String toString() {
        if (this.convertedString == null) {
            try {
                this.convertedString = new String(this.contents, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.convertedString = "";
            }
        }
        return this.convertedString;
    }
}

