/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.endpoint.protocol;

import com.taobao.top.link.endpoint.Message;
import com.taobao.top.link.endpoint.MessageIO;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;

public class MessageEncoder01
implements MessageIO.MessageEncoder {
    public void writeMessage(ByteBuffer buffer, Message message) {
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)1);
        buffer.put((byte)message.messageType);
        if (message.statusCode > 0) {
            buffer.putShort((short)2);
            buffer.putInt(message.statusCode);
        }
        if (message.statusPhase != null && message.statusPhase != "") {
            buffer.putShort((short)3);
            MessageEncoder01.writeCountedString(buffer, message.statusPhase);
        }
        if (message.flag > 0) {
            buffer.putShort((short)4);
            buffer.putInt(message.flag);
        }
        if (message.token != null && !message.token.equals("")) {
            buffer.putShort((short)5);
            MessageEncoder01.writeCountedString(buffer, message.token);
        }
        if (message.content != null) {
            for (Map.Entry<String, Object> i : message.content.entrySet()) {
                MessageEncoder01.writeCustomHeader(buffer, i.getKey(), i.getValue());
            }
        }
        buffer.putShort((short)0);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.flip();
    }

    private static void writeCountedString(ByteBuffer buffer, String value) {
        int strLength = 0;
        if (value != null) {
            strLength = value.length();
        }
        if (strLength > 0) {
            byte[] strBytes = value.getBytes(Charset.forName("UTF-8"));
            buffer.putInt(strBytes.length);
            buffer.put(strBytes);
        } else {
            buffer.putInt(0);
        }
    }

    private static void writeCustomHeader(ByteBuffer buffer, String name, Object value) {
        buffer.putShort((short)1);
        MessageEncoder01.writeCountedString(buffer, name);
        MessageEncoder01.writeCustomValue(buffer, value);
    }

    private static void writeCustomValue(ByteBuffer buffer, Object value) {
        if (value == null) {
            buffer.put((byte)0);
            return;
        }
        Class<?> type = value.getClass();
        if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            buffer.put((byte)2);
            buffer.put((Byte)value);
        } else if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            buffer.put((byte)3);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort((Short)value);
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            buffer.put((byte)4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt((Integer)value);
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else if (Long.TYPE.equals(type) || Long.class.equals(type)) {
            buffer.put((byte)5);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putLong((Long)value);
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else if (Date.class.equals(type)) {
            buffer.put((byte)6);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putLong(((Date)value).getTime());
            buffer.order(ByteOrder.BIG_ENDIAN);
        } else {
            buffer.put((byte)1);
            MessageEncoder01.writeCountedString(buffer, (String)value);
        }
    }
}

