/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.remoting;

import com.taobao.top.link.remoting.NettyRemotingProtocolHandle;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyRemotingDecoder
extends ReplayingDecoder<State> {
    private NettyRemotingProtocolHandle handle;
    private int payloadBytesRead;
    private int payloadLength;
    private ChannelBuffer payload;

    public NettyRemotingDecoder() {
        super((Enum)State.HEADER);
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, State state) throws Exception {
        switch (state) {
            case HEADER: {
                this.payloadBytesRead = 0;
                this.payloadLength = -1;
                this.payload = null;
                this.handle = new NettyRemotingProtocolHandle(buffer);
                this.handle.preamble = this.handle.ReadPreamble();
                this.handle.majorVersion = this.handle.ReadMajorVersion();
                this.handle.minorVersion = this.handle.ReadMinorVersion();
                this.handle.operation = this.handle.ReadOperation();
                this.handle.contentDelimiter = this.handle.ReadContentDelimiter();
                this.payloadLength = this.handle.ReadContentLength();
                this.handle.setContentLength(this.payloadLength);
                this.handle.transportHeaders = this.handle.ReadTransportHeaders();
                this.checkpoint(State.PAYLOAD);
            }
            case PAYLOAD: {
                int rbytes = this.actualReadableBytes();
                ChannelBuffer payloadBuffer = null;
                long willHaveReadByteCount = this.payloadBytesRead + rbytes;
                if (willHaveReadByteCount == (long)this.payloadLength) {
                    payloadBuffer = buffer.readBytes(rbytes);
                } else {
                    if (willHaveReadByteCount < (long)this.payloadLength) {
                        payloadBuffer = buffer.readBytes(rbytes);
                        if (this.payload == null) {
                            this.payload = channel.getConfig().getBufferFactory().getBuffer(NettyRemotingDecoder.toFrameLength(this.payloadLength));
                        }
                        this.payload.writeBytes(payloadBuffer);
                        this.payloadBytesRead += rbytes;
                        return null;
                    }
                    if (willHaveReadByteCount > (long)this.payloadLength) {
                        payloadBuffer = buffer.readBytes(NettyRemotingDecoder.toFrameLength(this.payloadLength - this.payloadBytesRead));
                    }
                }
                this.checkpoint(State.HEADER);
                if (this.payload == null) {
                    this.payload = payloadBuffer;
                } else {
                    this.payload.writeBytes(payloadBuffer);
                }
                this.handle.setContentBuffer(this.payload);
                return this.handle;
            }
        }
        throw new Error("Shouldn't reach here.");
    }

    private static int toFrameLength(long l) throws TooLongFrameException {
        if (l > Integer.MAX_VALUE) {
            throw new TooLongFrameException("Length:" + l);
        }
        return (int)l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        HEADER,
        PAYLOAD;

    }
}

