package io.easy.cache.autoconfigure;

import com.github.benmanes.caffeine.cache.Cache;
import io.easy.cache.anno.support.AutoConfigureBeans;
import io.easy.cache.core.CacheBuilder;
import io.easy.cache.core.embedded.CaffeineCacheBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-10-28 16:19
 * @descript:
 * @version: 1.0
 */
@Configuration
@ConditionalOnClass(Cache.class)
public class CaffeineAutoConfiguration {

    @Bean
    public CaffeineAutoInit caffeineAutoInit() {
        return new CaffeineAutoInit();
    }

    public static class CaffeineAutoInit implements ApplicationContextAware, InitializingBean {

        private ApplicationContext applicationContext;

        private CacheBuilder initCache() {
            return CaffeineCacheBuilder.createCaffeineCacheBuilder();
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        @Override
        public void afterPropertiesSet() {
            AutoConfigureBeans autoConfigureBeans = applicationContext.getBean(AutoConfigureBeans.class);
            autoConfigureBeans.setLocalCacheBuilders(initCache());
        }
    }
}
