/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console.filter;

import com.google.common.base.Optional;
import io.elasticjob.lite.console.domain.EventTraceDataSourceConfiguration;
import io.elasticjob.lite.console.domain.EventTraceDataSourceFactory;
import io.elasticjob.lite.console.domain.RegistryCenterConfiguration;
import io.elasticjob.lite.console.service.EventTraceDataSourceConfigurationService;
import io.elasticjob.lite.console.service.RegistryCenterConfigurationService;
import io.elasticjob.lite.console.service.impl.EventTraceDataSourceConfigurationServiceImpl;
import io.elasticjob.lite.console.service.impl.RegistryCenterConfigurationServiceImpl;
import io.elasticjob.lite.console.util.SessionEventTraceDataSourceConfiguration;
import io.elasticjob.lite.console.util.SessionRegistryCenterConfiguration;
import io.elasticjob.lite.lifecycle.internal.reg.RegistryCenterFactory;
import io.elasticjob.lite.reg.exception.RegException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class GlobalConfigurationFilter
implements Filter {
    private final RegistryCenterConfigurationService regCenterService = new RegistryCenterConfigurationServiceImpl();
    private final EventTraceDataSourceConfigurationService rdbService = new EventTraceDataSourceConfigurationServiceImpl();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpSession httpSession = httpRequest.getSession();
        if (null == httpSession.getAttribute("reg_center_config_key")) {
            this.loadActivatedRegCenter(httpSession);
        }
        if (null == httpSession.getAttribute("data_source_config_key")) {
            this.loadActivatedEventTraceDataSource(httpSession);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private void loadActivatedRegCenter(HttpSession httpSession) {
        String configName;
        boolean isConnected;
        Optional<RegistryCenterConfiguration> config = this.regCenterService.loadActivated();
        if (config.isPresent() && (isConnected = this.setRegistryCenterNameToSession(this.regCenterService.find(configName = ((RegistryCenterConfiguration)config.get()).getName(), this.regCenterService.loadAll()), httpSession))) {
            this.regCenterService.load(configName);
        }
    }

    private boolean setRegistryCenterNameToSession(RegistryCenterConfiguration regCenterConfig, HttpSession session) {
        session.setAttribute("reg_center_config_key", (Object)regCenterConfig);
        try {
            RegistryCenterFactory.createCoordinatorRegistryCenter((String)regCenterConfig.getZkAddressList(), (String)regCenterConfig.getNamespace(), (Optional)Optional.fromNullable((Object)regCenterConfig.getDigest()));
            SessionRegistryCenterConfiguration.setRegistryCenterConfiguration((RegistryCenterConfiguration)session.getAttribute("reg_center_config_key"));
        }
        catch (RegException ex) {
            return false;
        }
        return true;
    }

    private void loadActivatedEventTraceDataSource(HttpSession httpSession) {
        String configName;
        boolean isConnected;
        Optional<EventTraceDataSourceConfiguration> config = this.rdbService.loadActivated();
        if (config.isPresent() && (isConnected = this.setEventTraceDataSourceNameToSession(this.rdbService.find(configName = ((EventTraceDataSourceConfiguration)config.get()).getName(), this.rdbService.loadAll()), httpSession))) {
            this.rdbService.load(configName);
        }
    }

    private boolean setEventTraceDataSourceNameToSession(EventTraceDataSourceConfiguration dataSourceConfig, HttpSession session) {
        session.setAttribute("data_source_config_key", (Object)dataSourceConfig);
        try {
            EventTraceDataSourceFactory.createEventTraceDataSource(dataSourceConfig.getDriver(), dataSourceConfig.getUrl(), dataSourceConfig.getUsername(), (Optional<String>)Optional.fromNullable((Object)dataSourceConfig.getPassword()));
            SessionEventTraceDataSourceConfiguration.setDataSourceConfiguration((EventTraceDataSourceConfiguration)session.getAttribute("data_source_config_key"));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public void destroy() {
    }
}

