/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console.restful;

import com.google.common.base.Strings;
import io.elasticjob.lite.console.domain.EventTraceDataSourceConfiguration;
import io.elasticjob.lite.console.service.EventTraceDataSourceConfigurationService;
import io.elasticjob.lite.console.service.impl.EventTraceDataSourceConfigurationServiceImpl;
import io.elasticjob.lite.console.util.SessionEventTraceDataSourceConfiguration;
import io.elasticjob.lite.event.rdb.JobEventRdbSearch;
import io.elasticjob.lite.event.type.JobExecutionEvent;
import io.elasticjob.lite.event.type.JobStatusTraceEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.dbcp.BasicDataSource;

@Path(value="/event-trace")
public final class EventTraceHistoryRestfulApi {
    private EventTraceDataSourceConfiguration eventTraceDataSourceConfiguration = SessionEventTraceDataSourceConfiguration.getEventTraceDataSourceConfiguration();
    private EventTraceDataSourceConfigurationService eventTraceDataSourceConfigurationService = new EventTraceDataSourceConfigurationServiceImpl();

    @GET
    @Path(value="/execution")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public JobEventRdbSearch.Result<JobExecutionEvent> findJobExecutionEvents(@Context UriInfo uriInfo) throws ParseException {
        if (!this.eventTraceDataSourceConfigurationService.loadActivated().isPresent()) {
            return new JobEventRdbSearch.Result(Integer.valueOf(0), new ArrayList());
        }
        JobEventRdbSearch jobEventRdbSearch = new JobEventRdbSearch(this.setUpEventTraceDataSource());
        return jobEventRdbSearch.findJobExecutionEvents(this.buildCondition(uriInfo, new String[]{"jobName", "ip", "isSuccess"}));
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public JobEventRdbSearch.Result<JobStatusTraceEvent> findJobStatusTraceEvents(@Context UriInfo uriInfo) throws ParseException {
        if (!this.eventTraceDataSourceConfigurationService.loadActivated().isPresent()) {
            return new JobEventRdbSearch.Result(Integer.valueOf(0), new ArrayList());
        }
        JobEventRdbSearch jobEventRdbSearch = new JobEventRdbSearch(this.setUpEventTraceDataSource());
        return jobEventRdbSearch.findJobStatusTraceEvents(this.buildCondition(uriInfo, new String[]{"jobName", "source", "executionType", "state"}));
    }

    private DataSource setUpEventTraceDataSource() {
        BasicDataSource result = new BasicDataSource();
        result.setDriverClassName(this.eventTraceDataSourceConfiguration.getDriver());
        result.setUrl(this.eventTraceDataSourceConfiguration.getUrl());
        result.setUsername(this.eventTraceDataSourceConfiguration.getUsername());
        result.setPassword(this.eventTraceDataSourceConfiguration.getPassword());
        return result;
    }

    private JobEventRdbSearch.Condition buildCondition(UriInfo info, String[] params) throws ParseException {
        int perPage = 10;
        int page = 1;
        if (!Strings.isNullOrEmpty((String)((String)info.getQueryParameters().getFirst((Object)"per_page")))) {
            perPage = Integer.parseInt((String)info.getQueryParameters().getFirst((Object)"per_page"));
        }
        if (!Strings.isNullOrEmpty((String)((String)info.getQueryParameters().getFirst((Object)"page")))) {
            page = Integer.parseInt((String)info.getQueryParameters().getFirst((Object)"page"));
        }
        String sort = (String)info.getQueryParameters().getFirst((Object)"sort");
        String order = (String)info.getQueryParameters().getFirst((Object)"order");
        Date startTime = null;
        Date endTime = null;
        Map<String, Object> fields = this.getQueryParameters(info, params);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!Strings.isNullOrEmpty((String)((String)info.getQueryParameters().getFirst((Object)"startTime")))) {
            startTime = simpleDateFormat.parse((String)info.getQueryParameters().getFirst((Object)"startTime"));
        }
        if (!Strings.isNullOrEmpty((String)((String)info.getQueryParameters().getFirst((Object)"endTime")))) {
            endTime = simpleDateFormat.parse((String)info.getQueryParameters().getFirst((Object)"endTime"));
        }
        return new JobEventRdbSearch.Condition(perPage, page, sort, order, startTime, endTime, fields);
    }

    private Map<String, Object> getQueryParameters(UriInfo info, String[] params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String each : params) {
            if (Strings.isNullOrEmpty((String)((String)info.getQueryParameters().getFirst((Object)each)))) continue;
            result.put(each, info.getQueryParameters().getFirst((Object)each));
        }
        return result;
    }
}

