/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console.restful;

import com.google.common.base.Optional;
import io.elasticjob.lite.console.service.JobAPIService;
import io.elasticjob.lite.console.service.impl.JobAPIServiceImpl;
import io.elasticjob.lite.lifecycle.domain.JobBriefInfo;
import io.elasticjob.lite.lifecycle.domain.ShardingInfo;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/jobs")
public final class JobOperationRestfulApi {
    private JobAPIService jobAPIService = new JobAPIServiceImpl();

    @GET
    @Path(value="/count")
    public int getJobsTotalCount() {
        return this.jobAPIService.getJobStatisticsAPI().getJobsTotalCount();
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<JobBriefInfo> getAllJobsBriefInfo() {
        return this.jobAPIService.getJobStatisticsAPI().getAllJobsBriefInfo();
    }

    @POST
    @Path(value="/{jobName}/trigger")
    public void triggerJob(@PathParam(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().trigger(Optional.of((Object)jobName), Optional.absent());
    }

    @POST
    @Path(value="/{jobName}/disable")
    @Consumes(value={"application/json"})
    public void disableJob(@PathParam(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().disable(Optional.of((Object)jobName), Optional.absent());
    }

    @DELETE
    @Path(value="/{jobName}/disable")
    @Consumes(value={"application/json"})
    public void enableJob(@PathParam(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().enable(Optional.of((Object)jobName), Optional.absent());
    }

    @POST
    @Path(value="/{jobName}/shutdown")
    @Consumes(value={"application/json"})
    public void shutdownJob(@PathParam(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().shutdown(Optional.of((Object)jobName), Optional.absent());
    }

    @GET
    @Path(value="/{jobName}/sharding")
    @Produces(value={"application/json"})
    public Collection<ShardingInfo> getShardingInfo(@PathParam(value="jobName") String jobName) {
        return this.jobAPIService.getShardingStatisticsAPI().getShardingInfo(jobName);
    }

    @POST
    @Path(value="/{jobName}/sharding/{item}/disable")
    @Consumes(value={"application/json"})
    public void disableSharding(@PathParam(value="jobName") String jobName, @PathParam(value="item") String item) {
        this.jobAPIService.getShardingOperateAPI().disable(jobName, item);
    }

    @DELETE
    @Path(value="/{jobName}/sharding/{item}/disable")
    @Consumes(value={"application/json"})
    public void enableSharding(@PathParam(value="jobName") String jobName, @PathParam(value="item") String item) {
        this.jobAPIService.getShardingOperateAPI().enable(jobName, item);
    }
}

