/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console.restful.config;

import com.google.common.base.Optional;
import io.elasticjob.lite.console.domain.EventTraceDataSourceConfiguration;
import io.elasticjob.lite.console.domain.EventTraceDataSourceFactory;
import io.elasticjob.lite.console.service.EventTraceDataSourceConfigurationService;
import io.elasticjob.lite.console.service.impl.EventTraceDataSourceConfigurationServiceImpl;
import io.elasticjob.lite.console.util.SessionEventTraceDataSourceConfiguration;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Path(value="/data-source")
public final class EventTraceDataSourceRestfulApi {
    public static final String DATA_SOURCE_CONFIG_KEY = "data_source_config_key";
    private EventTraceDataSourceConfigurationService eventTraceDataSourceConfigurationService = new EventTraceDataSourceConfigurationServiceImpl();

    @GET
    @Path(value="/activated")
    public boolean activated(@Context HttpServletRequest request) {
        return this.eventTraceDataSourceConfigurationService.loadActivated().isPresent();
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<EventTraceDataSourceConfiguration> load(@Context HttpServletRequest request) {
        Optional<EventTraceDataSourceConfiguration> dataSourceConfig = this.eventTraceDataSourceConfigurationService.loadActivated();
        if (dataSourceConfig.isPresent()) {
            this.setDataSourceNameToSession((EventTraceDataSourceConfiguration)dataSourceConfig.get(), request.getSession());
        }
        return this.eventTraceDataSourceConfigurationService.loadAll().getEventTraceDataSourceConfiguration();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public boolean add(EventTraceDataSourceConfiguration config) {
        return this.eventTraceDataSourceConfigurationService.add(config);
    }

    @DELETE
    @Consumes(value={"application/json"})
    public void delete(EventTraceDataSourceConfiguration config) {
        this.eventTraceDataSourceConfigurationService.delete(config.getName());
    }

    @POST
    @Path(value="/connectTest")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public boolean connectTest(EventTraceDataSourceConfiguration config, @Context HttpServletRequest request) {
        return this.setDataSourceNameToSession(config, request.getSession());
    }

    @POST
    @Path(value="/connect")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public boolean connect(EventTraceDataSourceConfiguration config, @Context HttpServletRequest request) {
        boolean isConnected = this.setDataSourceNameToSession(this.eventTraceDataSourceConfigurationService.find(config.getName(), this.eventTraceDataSourceConfigurationService.loadAll()), request.getSession());
        if (isConnected) {
            this.eventTraceDataSourceConfigurationService.load(config.getName());
        }
        return isConnected;
    }

    private boolean setDataSourceNameToSession(EventTraceDataSourceConfiguration dataSourceConfig, HttpSession session) {
        session.setAttribute(DATA_SOURCE_CONFIG_KEY, (Object)dataSourceConfig);
        try {
            EventTraceDataSourceFactory.createEventTraceDataSource(dataSourceConfig.getDriver(), dataSourceConfig.getUrl(), dataSourceConfig.getUsername(), (Optional<String>)Optional.fromNullable((Object)dataSourceConfig.getPassword()));
            SessionEventTraceDataSourceConfiguration.setDataSourceConfiguration((EventTraceDataSourceConfiguration)session.getAttribute(DATA_SOURCE_CONFIG_KEY));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

