/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console.restful.config;

import com.google.common.base.Optional;
import io.elasticjob.lite.console.domain.RegistryCenterConfiguration;
import io.elasticjob.lite.console.service.RegistryCenterConfigurationService;
import io.elasticjob.lite.console.service.impl.RegistryCenterConfigurationServiceImpl;
import io.elasticjob.lite.console.util.SessionRegistryCenterConfiguration;
import io.elasticjob.lite.lifecycle.internal.reg.RegistryCenterFactory;
import io.elasticjob.lite.reg.exception.RegException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;

@Path(value="/registry-center")
public final class RegistryCenterRestfulApi {
    public static final String REG_CENTER_CONFIG_KEY = "reg_center_config_key";
    private RegistryCenterConfigurationService regCenterService = new RegistryCenterConfigurationServiceImpl();

    @GET
    @Path(value="/activated")
    public boolean activated(@Context HttpServletRequest request) {
        return this.regCenterService.loadActivated().isPresent();
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<RegistryCenterConfiguration> load(@Context HttpServletRequest request) {
        Optional<RegistryCenterConfiguration> regCenterConfig = this.regCenterService.loadActivated();
        if (regCenterConfig.isPresent()) {
            this.setRegistryCenterNameToSession((RegistryCenterConfiguration)regCenterConfig.get(), request.getSession());
        }
        return this.regCenterService.loadAll().getRegistryCenterConfiguration();
    }

    @POST
    @Produces(value={"application/json"})
    public boolean add(RegistryCenterConfiguration config) {
        return this.regCenterService.add(config);
    }

    @DELETE
    @Consumes(value={"application/json"})
    public void delete(RegistryCenterConfiguration config) {
        this.regCenterService.delete(config.getName());
    }

    @POST
    @Path(value="/connect")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public boolean connect(RegistryCenterConfiguration config, @Context HttpServletRequest request) {
        boolean isConnected = this.setRegistryCenterNameToSession(this.regCenterService.find(config.getName(), this.regCenterService.loadAll()), request.getSession());
        if (isConnected) {
            this.regCenterService.load(config.getName());
        }
        return isConnected;
    }

    private boolean setRegistryCenterNameToSession(RegistryCenterConfiguration regCenterConfig, HttpSession session) {
        session.setAttribute(REG_CENTER_CONFIG_KEY, (Object)regCenterConfig);
        try {
            RegistryCenterFactory.createCoordinatorRegistryCenter((String)regCenterConfig.getZkAddressList(), (String)regCenterConfig.getNamespace(), (Optional)Optional.fromNullable((Object)regCenterConfig.getDigest()));
            SessionRegistryCenterConfiguration.setRegistryCenterConfiguration((RegistryCenterConfiguration)session.getAttribute(REG_CENTER_CONFIG_KEY));
        }
        catch (RegException ex) {
            return false;
        }
        return true;
    }
}

