/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console;

import com.google.common.base.Optional;
import io.elasticjob.lite.console.filter.GlobalConfigurationFilter;
import io.elasticjob.lite.console.restful.JobOperationRestfulApi;
import io.elasticjob.lite.lifecycle.restful.RestfulServer;
import io.elasticjob.lite.lifecycle.security.WwwAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsoleBootstrap {
    private static final Logger log = LoggerFactory.getLogger(ConsoleBootstrap.class);
    private static final String CONSOLE_PATH = "console";

    public static void main(String[] args) throws Exception {
        int port = 8899;
        if (1 == args.length) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                log.warn("Wrong port format, using default port 8899 instead.");
            }
        }
        RestfulServer restfulServer = new RestfulServer(port);
        restfulServer.addFilter(GlobalConfigurationFilter.class, "*.html").addFilter(WwwAuthFilter.class, "/").addFilter(WwwAuthFilter.class, "*.html").start(JobOperationRestfulApi.class.getPackage().getName(), Optional.of((Object)CONSOLE_PATH));
    }

    private ConsoleBootstrap() {
    }
}

