/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console.domain;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.elasticjob.lite.console.domain.EventTraceDataSource;
import io.elasticjob.lite.console.domain.EventTraceDataSourceConfiguration;
import java.util.concurrent.ConcurrentHashMap;

public final class EventTraceDataSourceFactory {
    private static final ConcurrentHashMap<HashCode, EventTraceDataSource> DATA_SOURCE_REGISTRY = new ConcurrentHashMap();

    public static EventTraceDataSource createEventTraceDataSource(String driver, String url, String username, Optional<String> password) {
        HashCode hashCode;
        EventTraceDataSource result;
        Hasher hasher = Hashing.md5().newHasher().putString((CharSequence)driver, Charsets.UTF_8).putString((CharSequence)url, Charsets.UTF_8);
        if (!Strings.isNullOrEmpty((String)username)) {
            hasher.putString((CharSequence)username, Charsets.UTF_8);
        }
        if (password.isPresent()) {
            hasher.putString((CharSequence)password.get(), Charsets.UTF_8);
        }
        if (null != (result = DATA_SOURCE_REGISTRY.get(hashCode = hasher.hash()))) {
            return result;
        }
        EventTraceDataSourceConfiguration eventTraceDataSourceConfiguration = new EventTraceDataSourceConfiguration(driver, url, username);
        if (password.isPresent()) {
            eventTraceDataSourceConfiguration.setPassword((String)password.get());
        }
        result = new EventTraceDataSource(eventTraceDataSourceConfiguration);
        result.init();
        DATA_SOURCE_REGISTRY.put(hashCode, result);
        return result;
    }

    private EventTraceDataSourceFactory() {
    }
}

