/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console.repository.impl;

import io.elasticjob.lite.console.exception.JobConsoleException;
import io.elasticjob.lite.console.repository.XmlRepository;
import io.elasticjob.lite.console.util.HomeFolderUtils;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public abstract class AbstractXmlRepositoryImpl<E>
implements XmlRepository<E> {
    private final File file;
    private final Class<E> clazz;
    private JAXBContext jaxbContext;

    protected AbstractXmlRepositoryImpl(String fileName, Class<E> clazz) {
        this.file = new File(HomeFolderUtils.getFilePathInHomeFolder(fileName));
        this.clazz = clazz;
        HomeFolderUtils.createHomeFolderIfNotExisted();
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException ex) {
            throw new JobConsoleException((Exception)((Object)ex));
        }
    }

    @Override
    public synchronized E load() {
        if (!this.file.exists()) {
            try {
                return this.clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new JobConsoleException(ex);
            }
        }
        try {
            Object result = this.jaxbContext.createUnmarshaller().unmarshal(this.file);
            return (E)result;
        }
        catch (JAXBException ex) {
            throw new JobConsoleException((Exception)((Object)ex));
        }
    }

    @Override
    public synchronized void save(E entity) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(entity, this.file);
        }
        catch (JAXBException ex) {
            throw new JobConsoleException((Exception)((Object)ex));
        }
    }
}

