/*
 * Decompiled with CFR 0.152.
 */
package io.elasticjob.lite.console.restful;

import com.google.common.base.Optional;
import io.elasticjob.lite.console.service.JobAPIService;
import io.elasticjob.lite.console.service.impl.JobAPIServiceImpl;
import io.elasticjob.lite.lifecycle.domain.JobBriefInfo;
import io.elasticjob.lite.lifecycle.domain.ServerBriefInfo;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/servers")
public final class ServerOperationRestfulApi {
    private JobAPIService jobAPIService = new JobAPIServiceImpl();

    @GET
    @Path(value="/count")
    public int getServersTotalCount() {
        return this.jobAPIService.getServerStatisticsAPI().getServersTotalCount();
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<ServerBriefInfo> getAllServersBriefInfo() {
        return this.jobAPIService.getServerStatisticsAPI().getAllServersBriefInfo();
    }

    @POST
    @Path(value="/{serverIp}/disable")
    public void disableServer(@PathParam(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().disable(Optional.absent(), Optional.of((Object)serverIp));
    }

    @DELETE
    @Path(value="/{serverIp}/disable")
    public void enableServer(@PathParam(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().enable(Optional.absent(), Optional.of((Object)serverIp));
    }

    @POST
    @Path(value="/{serverIp}/shutdown")
    public void shutdownServer(@PathParam(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().shutdown(Optional.absent(), Optional.of((Object)serverIp));
    }

    @DELETE
    @Path(value="/{serverIp}")
    public void removeServer(@PathParam(value="serverIp") String serverIp) {
        this.jobAPIService.getJobOperatorAPI().remove(Optional.absent(), Optional.of((Object)serverIp));
    }

    @GET
    @Path(value="/{serverIp}/jobs")
    @Produces(value={"application/json"})
    public Collection<JobBriefInfo> getJobs(@PathParam(value="serverIp") String serverIp) {
        return this.jobAPIService.getJobStatisticsAPI().getJobsBriefInfo(serverIp);
    }

    @POST
    @Path(value="/{serverIp}/jobs/{jobName}/disable")
    public void disableServerJob(@PathParam(value="serverIp") String serverIp, @PathParam(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().disable(Optional.of((Object)jobName), Optional.of((Object)serverIp));
    }

    @DELETE
    @Path(value="/{serverIp}/jobs/{jobName}/disable")
    public void enableServerJob(@PathParam(value="serverIp") String serverIp, @PathParam(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().enable(Optional.of((Object)jobName), Optional.of((Object)serverIp));
    }

    @POST
    @Path(value="/{serverIp}/jobs/{jobName}/shutdown")
    public void shutdownServerJob(@PathParam(value="serverIp") String serverIp, @PathParam(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().shutdown(Optional.of((Object)jobName), Optional.of((Object)serverIp));
    }

    @DELETE
    @Path(value="/{serverIp}/jobs/{jobName}")
    public void removeServerJob(@PathParam(value="serverIp") String serverIp, @PathParam(value="jobName") String jobName) {
        this.jobAPIService.getJobOperatorAPI().remove(Optional.of((Object)jobName), Optional.of((Object)serverIp));
    }
}

